/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeCT.AttributeReader;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.CodeReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;

public final class LineNumberTableReader
extends AttributeReader {
    public LineNumberTableReader(ClassReader.AttrIterator attrIterator) throws InvalidClassFileException {
        super(attrIterator, "LineNumberTable");
        int n = this.attr + 6;
        this.checkSize(n, 2);
        int n2 = this.cr.getUShort(n);
        this.checkSize(n += 2, n2 * 4);
    }

    public int[] getRawTable() {
        int n = this.cr.getUShort(this.attr + 6);
        int[] nArray = new int[n * 2];
        int n2 = this.attr + 8;
        int n3 = 0;
        while (n3 < nArray.length) {
            nArray[n3] = this.cr.getUShort(n2);
            n2 += 2;
            ++n3;
        }
        return nArray;
    }

    public static int[] makeBytecodeToSourceMap(CodeReader codeReader) throws InvalidClassFileException, IllegalArgumentException {
        int n;
        int n2;
        int n3;
        if (codeReader == null) {
            throw new IllegalArgumentException();
        }
        int[] nArray = null;
        ClassReader classReader = codeReader.getClassReader();
        ClassReader.AttrIterator attrIterator = new ClassReader.AttrIterator();
        codeReader.initAttributeIterator(attrIterator);
        while (attrIterator.isValid()) {
            if (attrIterator.getName().equals("LineNumberTable")) {
                if (nArray == null) {
                    nArray = new int[codeReader.getBytecodeLength()];
                }
                new LineNumberTableReader(attrIterator);
                n3 = attrIterator.getRawOffset();
                n2 = classReader.getUShort(n3 + 6);
                n = n3 + 8;
                int n4 = 0;
                while (n4 < n2) {
                    int n5 = classReader.getUShort(n);
                    int n6 = classReader.getUShort(n + 2);
                    n += 4;
                    if (n5 < 0 || n5 >= nArray.length) {
                        throw new InvalidClassFileException(n, "Invalid bytecode offset " + n5 + " in LineNumberTable");
                    }
                    nArray[n5] = n6;
                    ++n4;
                }
            }
            attrIterator.advance();
        }
        if (nArray != null) {
            n3 = 0;
            n2 = 0;
            while (n2 < nArray.length) {
                n = nArray[n2];
                if (n == 0) {
                    nArray[n2] = n3;
                } else {
                    n3 = n;
                }
                ++n2;
            }
        }
        return nArray;
    }
}

