/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.mwapi.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.psammead.mwapi.Location;
import net.psammead.mwapi.NameSpace;
import net.psammead.mwapi.connection.TitleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Site {
    public final String family;
    public final String language;
    public final String protocol;
    public final String hostName;
    public final String rawPath;
    public final String prettyPath;
    public final String apiPath;
    public final String charSet;
    public final String titleCase;
    public final String uselang;
    public final Map<Integer, String> nameSpaceNames;
    public final Map<String, String> specialPageNames;
    public final Map<String, String> messages;
    public final String wiki;
    private Map<Integer, NameSpace> nameSpaces;

    public Site(String family, String language, String protocol, String hostName, String actionPath, String readPath, String apiPath, String charSet, String titleCase, String uselang, Map<Integer, String> nameSpaceNames, Map<String, String> specialPageNames, Map<String, String> messages) {
        int index;
        this.family = family;
        this.language = language;
        this.protocol = protocol;
        this.hostName = hostName;
        this.rawPath = actionPath;
        this.prettyPath = readPath;
        this.apiPath = apiPath;
        this.charSet = charSet.toUpperCase();
        this.titleCase = titleCase;
        this.uselang = uselang;
        this.nameSpaceNames = Collections.unmodifiableMap(new TreeMap<Integer, String>(nameSpaceNames));
        this.specialPageNames = Collections.unmodifiableMap(new TreeMap<String, String>(specialPageNames));
        this.messages = Collections.unmodifiableMap(new TreeMap<String, String>(messages));
        this.wiki = TitleUtil.buildWiki(family, language);
        this.nameSpaces = new HashMap<Integer, NameSpace>();
        for (Integer key : nameSpaceNames.keySet()) {
            index = key;
            String name = nameSpaceNames.get(key);
            NameSpace nameSpace = new NameSpace(index, name);
            this.nameSpaces.put(key, nameSpace);
        }
        for (Integer key : this.nameSpaces.keySet()) {
            index = key;
            NameSpace nameSpace = this.nameSpaces.get(key);
            if (nameSpace.isSpecial()) {
                nameSpace.setDiscussionTwin(null);
                continue;
            }
            try {
                nameSpace.setDiscussionTwin(this.nameSpace(index ^ 1));
            }
            catch (IllegalArgumentException e) {
                nameSpace.setDiscussionTwin(null);
            }
        }
    }

    public Location location(String title) {
        return new Location(this.wiki, title);
    }

    public Location location(int nameSpace, String title) {
        return this.location(this.nameSpace(nameSpace).addTo(title));
    }

    public String message(String key) {
        return this.messages.get(key);
    }

    public NameSpace nameSpace(int index) {
        Integer key = new Integer(index);
        NameSpace nameSpace = this.nameSpaces.get(key);
        if (nameSpace == null) {
            throw new IllegalArgumentException("nameSpace unknown: " + index);
        }
        return nameSpace;
    }

    public NameSpace nameSpaceForTitle(String title) {
        for (Integer key : this.nameSpaces.keySet()) {
            int index = key;
            NameSpace nameSpace = this.nameSpaces.get(key);
            if (index == 0 || !nameSpace.matches(title)) continue;
            return nameSpace;
        }
        return this.nameSpace(0);
    }

    public String toString() {
        return this.language != null ? this.family + ":" + this.language : this.family;
    }
}

