/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.mwapi.ui.action;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import net.psammead.mwapi.MediaWiki;
import net.psammead.mwapi.MediaWikiException;
import net.psammead.mwapi.config.Site;
import net.psammead.mwapi.connection.Connection;
import net.psammead.mwapi.connection.URLManager;
import net.psammead.mwapi.net.ProgressFilePartSource;
import net.psammead.mwapi.ui.ProgressCallback;
import net.psammead.mwapi.ui.UnexpectedAnswerException;
import net.psammead.mwapi.ui.UnsupportedURLException;
import net.psammead.util.Logger;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.util.EncodingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ActionBase {
    protected final MediaWiki mediaWiki;
    protected final Connection connection;
    protected final Site site;
    protected final URLManager urlManager;
    protected final HttpClient client;
    protected final String userAgent;
    protected final Logger logger;

    protected ActionBase(MediaWiki mediaWiki, Connection connection) {
        this.mediaWiki = mediaWiki;
        this.connection = connection;
        this.site = connection.site;
        this.urlManager = connection.urlManager;
        this.client = connection.client;
        this.userAgent = mediaWiki.getUserAgent();
        this.logger = mediaWiki.getLogger();
    }

    public abstract void execute() throws MediaWikiException;

    protected URL extractRedirectURL(HttpMethod method) throws UnexpectedAnswerException, UnsupportedURLException {
        Header header = method.getResponseHeader("location");
        if (header == null) {
            throw (UnexpectedAnswerException)new UnexpectedAnswerException("missing location header in the response").addFactoid("status", method.getStatusLine());
        }
        try {
            URI methodURI = method.getURI();
            URL baseURL = new URL(methodURI.getURI());
            URL resultURL = new URL(baseURL, header.getValue());
            return resultURL;
        }
        catch (URIException e) {
            throw new UnsupportedURLException("malformed url", e);
        }
        catch (MalformedURLException e) {
            throw new UnsupportedURLException("malformed url", e);
        }
    }

    protected GetMethod createGetMethod(String url, Map<String, String> parameters) {
        GetMethod method = new GetMethod(url);
        method.setFollowRedirects(false);
        method.addRequestHeader("User-Agent", this.userAgent);
        NameValuePair[] methodParams = new NameValuePair[parameters.size() + 1];
        int index = 0;
        methodParams[index++] = new NameValuePair("uselang", this.site.uselang);
        for (Map.Entry<String, String> param : parameters.entrySet()) {
            methodParams[index++] = new NameValuePair(param.getKey(), param.getValue());
        }
        String query = EncodingUtil.formUrlEncode((NameValuePair[])methodParams, (String)this.site.charSet);
        method.setQueryString(query);
        return method;
    }

    protected PostMethod createPostMethod(String url, Map<String, String> parameters) {
        PostMethod method = new PostMethod(url);
        method.setFollowRedirects(false);
        method.addRequestHeader("User-Agent", this.userAgent);
        method.addRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + this.site.charSet);
        method.addParameter("uselang", this.site.uselang);
        for (Map.Entry<String, String> param : parameters.entrySet()) {
            method.addParameter(param.getKey(), param.getValue());
        }
        return method;
    }

    protected PostMethod createMultipartPostMethod(String url, Map<String, String> parameters, String fileField, File file, ProgressCallback progressListener) {
        PostMethod method = new PostMethod(url);
        method.setFollowRedirects(false);
        method.addRequestHeader("User-Agent", this.userAgent);
        ArrayList<Object> partList = new ArrayList<Object>();
        partList.add(new StringPart("uselang", this.site.uselang, this.site.charSet));
        for (Map.Entry<String, String> param : parameters.entrySet()) {
            partList.add(new StringPart(param.getKey(), param.getValue(), this.site.charSet));
        }
        partList.add(new FilePart(fileField, (PartSource)new ProgressFilePartSource(file, progressListener), "application/octet-stream", this.site.charSet));
        Part[] parts = partList.toArray(new Part[partList.size()]);
        method.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, method.getParams()));
        return method;
    }

    protected void debug(HttpMethod method) throws URIException {
        this.logger.debug("HTTP " + method.getName() + " " + method.getURI().toString() + " " + method.getStatusLine());
    }
}

