/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.mwapi.ui.action;

import net.psammead.mwapi.MediaWiki;
import net.psammead.mwapi.MediaWikiException;
import net.psammead.mwapi.connection.Connection;
import net.psammead.mwapi.ui.MoveCallback;
import net.psammead.mwapi.ui.UnexpectedAnswerException;
import net.psammead.mwapi.ui.action.UiFormActionBase;
import net.psammead.mwapi.ui.action.response.ResponseData;
import net.psammead.mwapi.ui.action.response.ResponseHandler;
import net.psammead.mwapi.ui.action.response.UnexpectedAnswerHandler;

public class PageMoveAction
extends UiFormActionBase {
    public PageMoveAction(MediaWiki mediaWiki, Connection connection, String oldTitle, String newTitle, String reason, MoveCallback moveCallback) {
        this(mediaWiki, connection, oldTitle, newTitle, reason, false, moveCallback);
    }

    protected PageMoveAction(final MediaWiki mediaWiki, final Connection connection, final String oldTitle, final String newTitle, final String reason, final boolean confirmOverwrite, final MoveCallback moveCallback) {
        super(mediaWiki, connection);
        this.fetchTitle(this.specialPage("Movepage"));
        this.fetchArg("target", oldTitle);
        this.formName("movepage");
        this.formId("movepage");
        this.copyArg("wpEditToken");
        this.actionArg("wpOldTitle", oldTitle);
        this.actionArg("wpNewTitle", newTitle);
        this.actionArg("wpReason", reason);
        if (confirmOverwrite) {
            this.actionArg("wpConfirm", "1");
        }
        this.actionArg("wpMove", "yes");
        this.actionArg("action", "submit");
        this.responseMessageHandler(200, "delete_and_move_text", new ResponseHandler(){

            public boolean handle(ResponseData data) throws MediaWikiException {
                if (confirmOverwrite || moveCallback == null) {
                    throw new UnexpectedAnswerException("could not overwrite").addFactoid("status", data.statusLine);
                }
                boolean confirm = moveCallback.ignoreDeleteAndMoveText();
                if (confirm) {
                    PageMoveAction retry = new PageMoveAction(mediaWiki, connection, oldTitle, newTitle, reason, true, moveCallback);
                    retry.execute();
                }
                return true;
            }
        });
        this.responseMessageHandler(200, "talkexists", new UnexpectedAnswerHandler("talkexists"));
        this.responseMessageHandler(200, "talkpagemoved", new UnexpectedAnswerHandler("talkpagemoved"));
        this.responseMessageHandler(200, "talkpagenotmoved", new UnexpectedAnswerHandler("talkpagemoved"));
        this.responseHandler(302, new ResponseHandler(){

            public boolean handle(ResponseData data) throws MediaWikiException {
                System.err.println("### target=" + data.redirect);
                return true;
            }
        });
    }
}

