/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util;

import java.util.HashMap;
import java.util.Map;

public final class HTMLEntities {
    private static final Map<Character, String> charToEntity = new HashMap<Character, String>();
    private static final Map<String, Character> entityToChar = new HashMap<String, Character>();
    private static int shortEntity = Integer.MIN_VALUE;
    private static int longEntity = Integer.MAX_VALUE;

    private HTMLEntities() {
    }

    public static String encode(String s) {
        StringBuilder out = new StringBuilder();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            out.append(HTMLEntities.encode(s.charAt(i)));
        }
        return out.toString();
    }

    public static String encode(char c) {
        String s = charToEntity.get(new Character(c));
        if (s != null) {
            return "&" + s + ";";
        }
        if (c < '\u0100') {
            return Character.toString(c);
        }
        return "&#" + Integer.toString(c) + ";";
    }

    public static String decode(String s) {
        if (s.indexOf(38) < 0) {
            return s;
        }
        StringBuilder out = new StringBuilder();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch;
            String may;
            int pos;
            block10: {
                pos = s.indexOf(38, i);
                if (pos < 0) {
                    out.append(s.substring(i));
                    break;
                }
                out.append(s.substring(i, pos));
                i = pos;
                pos = s.indexOf(59, i);
                if (pos < 0) {
                    out.append("&");
                    continue;
                }
                if (pos - i - 1 < shortEntity || pos - i - 1 > longEntity) {
                    out.append('&');
                    continue;
                }
                may = s.substring(i + 1, pos);
                try {
                    if (may.startsWith("#x")) {
                        ch = (char)Integer.parseInt(may.substring(2), 16);
                        out.append(ch);
                        i = pos;
                        continue;
                    }
                    if (may.startsWith("#")) {
                        ch = (char)Integer.parseInt(may.substring(1));
                        out.append(ch);
                        i = pos;
                    }
                    break block10;
                }
                catch (NumberFormatException e) {
                    out.append('&');
                }
                continue;
            }
            Character chr = entityToChar.get(may);
            if (chr != null) {
                ch = chr.charValue();
                out.append(ch);
                i = pos;
                continue;
            }
            out.append('&');
        }
        return out.toString();
    }

    private static void associate(int character, String entity) {
        Character chr = new Character((char)character);
        charToEntity.put(chr, entity);
        entityToChar.put(entity, chr);
        int len = entity.length();
        if (len < shortEntity) {
            shortEntity = len;
        }
        if (len > longEntity) {
            longEntity = len;
        }
    }

    private static void build() {
        HTMLEntities.associate(34, "quot");
        HTMLEntities.associate(38, "amp");
        HTMLEntities.associate(60, "lt");
        HTMLEntities.associate(62, "gt");
        HTMLEntities.associate(160, "nbsp");
        HTMLEntities.associate(161, "iexcl");
        HTMLEntities.associate(162, "cent");
        HTMLEntities.associate(163, "pound");
        HTMLEntities.associate(164, "curren");
        HTMLEntities.associate(165, "yen");
        HTMLEntities.associate(166, "brvbar");
        HTMLEntities.associate(167, "sect");
        HTMLEntities.associate(168, "uml");
        HTMLEntities.associate(169, "copy");
        HTMLEntities.associate(170, "ordf");
        HTMLEntities.associate(171, "laquo");
        HTMLEntities.associate(172, "not");
        HTMLEntities.associate(173, "shy");
        HTMLEntities.associate(174, "reg");
        HTMLEntities.associate(175, "macr");
        HTMLEntities.associate(176, "deg");
        HTMLEntities.associate(177, "plusmn");
        HTMLEntities.associate(178, "sup2");
        HTMLEntities.associate(179, "sup3");
        HTMLEntities.associate(180, "acute");
        HTMLEntities.associate(181, "micro");
        HTMLEntities.associate(182, "para");
        HTMLEntities.associate(183, "middot");
        HTMLEntities.associate(184, "cedil");
        HTMLEntities.associate(185, "sup1");
        HTMLEntities.associate(186, "ordm");
        HTMLEntities.associate(187, "raquo");
        HTMLEntities.associate(188, "frac14");
        HTMLEntities.associate(189, "frac12");
        HTMLEntities.associate(190, "frac34");
        HTMLEntities.associate(191, "iquest");
        HTMLEntities.associate(192, "Agrave");
        HTMLEntities.associate(193, "Aacute");
        HTMLEntities.associate(194, "Acirc");
        HTMLEntities.associate(195, "Atilde");
        HTMLEntities.associate(196, "Auml");
        HTMLEntities.associate(197, "Aring");
        HTMLEntities.associate(198, "AElig");
        HTMLEntities.associate(199, "Ccedil");
        HTMLEntities.associate(200, "Egrave");
        HTMLEntities.associate(201, "Eacute");
        HTMLEntities.associate(202, "Ecirc");
        HTMLEntities.associate(203, "Euml");
        HTMLEntities.associate(204, "Igrave");
        HTMLEntities.associate(205, "Iacute");
        HTMLEntities.associate(206, "Icirc");
        HTMLEntities.associate(207, "Iuml");
        HTMLEntities.associate(208, "ETH");
        HTMLEntities.associate(209, "Ntilde");
        HTMLEntities.associate(210, "Ograve");
        HTMLEntities.associate(211, "Oacute");
        HTMLEntities.associate(212, "Ocirc");
        HTMLEntities.associate(213, "Otilde");
        HTMLEntities.associate(214, "Ouml");
        HTMLEntities.associate(215, "times");
        HTMLEntities.associate(216, "Oslash");
        HTMLEntities.associate(217, "Ugrave");
        HTMLEntities.associate(218, "Uacute");
        HTMLEntities.associate(219, "Ucirc");
        HTMLEntities.associate(220, "Uuml");
        HTMLEntities.associate(221, "Yacute");
        HTMLEntities.associate(222, "THORN");
        HTMLEntities.associate(223, "szlig");
        HTMLEntities.associate(224, "agrave");
        HTMLEntities.associate(225, "aacute");
        HTMLEntities.associate(226, "acirc");
        HTMLEntities.associate(227, "atilde");
        HTMLEntities.associate(228, "auml");
        HTMLEntities.associate(229, "aring");
        HTMLEntities.associate(230, "aelig");
        HTMLEntities.associate(231, "ccedil");
        HTMLEntities.associate(232, "egrave");
        HTMLEntities.associate(233, "eacute");
        HTMLEntities.associate(234, "ecirc");
        HTMLEntities.associate(235, "euml");
        HTMLEntities.associate(236, "igrave");
        HTMLEntities.associate(237, "iacute");
        HTMLEntities.associate(238, "icirc");
        HTMLEntities.associate(239, "iuml");
        HTMLEntities.associate(240, "eth");
        HTMLEntities.associate(241, "ntilde");
        HTMLEntities.associate(242, "ograve");
        HTMLEntities.associate(243, "oacute");
        HTMLEntities.associate(244, "ocirc");
        HTMLEntities.associate(245, "otilde");
        HTMLEntities.associate(246, "ouml");
        HTMLEntities.associate(247, "divide");
        HTMLEntities.associate(248, "oslash");
        HTMLEntities.associate(249, "ugrave");
        HTMLEntities.associate(250, "uacute");
        HTMLEntities.associate(251, "ucirc");
        HTMLEntities.associate(252, "uuml");
        HTMLEntities.associate(253, "yacute");
        HTMLEntities.associate(254, "thorn");
        HTMLEntities.associate(255, "yuml");
        HTMLEntities.associate(338, "OElig");
        HTMLEntities.associate(339, "oelig");
        HTMLEntities.associate(352, "Scaron");
        HTMLEntities.associate(353, "scaron");
        HTMLEntities.associate(376, "Yuml");
        HTMLEntities.associate(402, "fnof");
        HTMLEntities.associate(710, "circ");
        HTMLEntities.associate(732, "tilde");
        HTMLEntities.associate(913, "Alpha");
        HTMLEntities.associate(914, "Beta");
        HTMLEntities.associate(915, "Gamma");
        HTMLEntities.associate(916, "Delta");
        HTMLEntities.associate(917, "Epsilon");
        HTMLEntities.associate(918, "Zeta");
        HTMLEntities.associate(919, "Eta");
        HTMLEntities.associate(920, "Theta");
        HTMLEntities.associate(921, "Iota");
        HTMLEntities.associate(922, "Kappa");
        HTMLEntities.associate(923, "Lambda");
        HTMLEntities.associate(924, "Mu");
        HTMLEntities.associate(925, "Nu");
        HTMLEntities.associate(926, "Xi");
        HTMLEntities.associate(927, "Omicron");
        HTMLEntities.associate(928, "Pi");
        HTMLEntities.associate(929, "Rho");
        HTMLEntities.associate(931, "Sigma");
        HTMLEntities.associate(932, "Tau");
        HTMLEntities.associate(933, "Upsilon");
        HTMLEntities.associate(934, "Phi");
        HTMLEntities.associate(935, "Chi");
        HTMLEntities.associate(936, "Psi");
        HTMLEntities.associate(937, "Omega");
        HTMLEntities.associate(945, "alpha");
        HTMLEntities.associate(946, "beta");
        HTMLEntities.associate(947, "gamma");
        HTMLEntities.associate(948, "delta");
        HTMLEntities.associate(949, "epsilon");
        HTMLEntities.associate(950, "zeta");
        HTMLEntities.associate(951, "eta");
        HTMLEntities.associate(952, "theta");
        HTMLEntities.associate(953, "iota");
        HTMLEntities.associate(954, "kappa");
        HTMLEntities.associate(955, "lambda");
        HTMLEntities.associate(956, "mu");
        HTMLEntities.associate(957, "nu");
        HTMLEntities.associate(958, "xi");
        HTMLEntities.associate(959, "omicron");
        HTMLEntities.associate(960, "pi");
        HTMLEntities.associate(961, "rho");
        HTMLEntities.associate(962, "sigmaf");
        HTMLEntities.associate(963, "sigma");
        HTMLEntities.associate(964, "tau");
        HTMLEntities.associate(965, "upsilon");
        HTMLEntities.associate(966, "phi");
        HTMLEntities.associate(967, "chi");
        HTMLEntities.associate(968, "psi");
        HTMLEntities.associate(969, "omega");
        HTMLEntities.associate(977, "thetasym");
        HTMLEntities.associate(978, "upsih");
        HTMLEntities.associate(982, "piv");
        HTMLEntities.associate(8194, "ensp");
        HTMLEntities.associate(8195, "emsp");
        HTMLEntities.associate(8201, "thinsp");
        HTMLEntities.associate(8204, "zwnj");
        HTMLEntities.associate(8205, "zwj");
        HTMLEntities.associate(8206, "lrm");
        HTMLEntities.associate(8207, "rlm");
        HTMLEntities.associate(8211, "ndash");
        HTMLEntities.associate(8212, "mdash");
        HTMLEntities.associate(8216, "lsquo");
        HTMLEntities.associate(8217, "rsquo");
        HTMLEntities.associate(8218, "sbquo");
        HTMLEntities.associate(8220, "ldquo");
        HTMLEntities.associate(8221, "rdquo");
        HTMLEntities.associate(8222, "bdquo");
        HTMLEntities.associate(8224, "dagger");
        HTMLEntities.associate(8225, "Dagger");
        HTMLEntities.associate(8226, "bull");
        HTMLEntities.associate(8230, "hellip");
        HTMLEntities.associate(8240, "permil");
        HTMLEntities.associate(8242, "prime");
        HTMLEntities.associate(8243, "Prime");
        HTMLEntities.associate(8249, "lsaquo");
        HTMLEntities.associate(8250, "rsaquo");
        HTMLEntities.associate(8254, "oline");
        HTMLEntities.associate(8260, "frasl");
        HTMLEntities.associate(8364, "euro");
        HTMLEntities.associate(8465, "image");
        HTMLEntities.associate(8472, "weierp");
        HTMLEntities.associate(8476, "real");
        HTMLEntities.associate(8482, "trade");
        HTMLEntities.associate(8501, "alefsym");
        HTMLEntities.associate(8592, "larr");
        HTMLEntities.associate(8593, "uarr");
        HTMLEntities.associate(8594, "rarr");
        HTMLEntities.associate(8595, "darr");
        HTMLEntities.associate(8596, "harr");
        HTMLEntities.associate(8629, "crarr");
        HTMLEntities.associate(8656, "lArr");
        HTMLEntities.associate(8657, "uArr");
        HTMLEntities.associate(8658, "rArr");
        HTMLEntities.associate(8659, "dArr");
        HTMLEntities.associate(8660, "hArr");
        HTMLEntities.associate(8704, "forall");
        HTMLEntities.associate(8706, "part");
        HTMLEntities.associate(8707, "exist");
        HTMLEntities.associate(8709, "empty");
        HTMLEntities.associate(8711, "nabla");
        HTMLEntities.associate(8712, "isin");
        HTMLEntities.associate(8713, "notin");
        HTMLEntities.associate(8715, "ni");
        HTMLEntities.associate(8719, "prod");
        HTMLEntities.associate(8721, "sum");
        HTMLEntities.associate(8722, "minus");
        HTMLEntities.associate(8727, "lowast");
        HTMLEntities.associate(8730, "radic");
        HTMLEntities.associate(8733, "prop");
        HTMLEntities.associate(8734, "infin");
        HTMLEntities.associate(8736, "ang");
        HTMLEntities.associate(8743, "and");
        HTMLEntities.associate(8744, "or");
        HTMLEntities.associate(8745, "cap");
        HTMLEntities.associate(8746, "cup");
        HTMLEntities.associate(8747, "int");
        HTMLEntities.associate(8756, "there4");
        HTMLEntities.associate(8764, "sim");
        HTMLEntities.associate(8773, "cong");
        HTMLEntities.associate(8776, "asymp");
        HTMLEntities.associate(8800, "ne");
        HTMLEntities.associate(8801, "equiv");
        HTMLEntities.associate(8804, "le");
        HTMLEntities.associate(8805, "ge");
        HTMLEntities.associate(8834, "sub");
        HTMLEntities.associate(8835, "sup");
        HTMLEntities.associate(8836, "nsub");
        HTMLEntities.associate(8838, "sube");
        HTMLEntities.associate(8839, "supe");
        HTMLEntities.associate(8853, "oplus");
        HTMLEntities.associate(8855, "otimes");
        HTMLEntities.associate(8869, "perp");
        HTMLEntities.associate(8901, "sdot");
        HTMLEntities.associate(8968, "lceil");
        HTMLEntities.associate(8969, "rceil");
        HTMLEntities.associate(8970, "lfloor");
        HTMLEntities.associate(8971, "rfloor");
        HTMLEntities.associate(9001, "lang");
        HTMLEntities.associate(9002, "rang");
        HTMLEntities.associate(9674, "loz");
        HTMLEntities.associate(9824, "spades");
        HTMLEntities.associate(9827, "clubs");
        HTMLEntities.associate(9829, "hearts");
        HTMLEntities.associate(9830, "diams");
    }

    static {
        HTMLEntities.build();
        int min = "#0".length();
        if (shortEntity < min) {
            shortEntity = min;
        }
        if (longEntity < min) {
            longEntity = min;
        }
    }
}

