/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util;

import java.io.PrintStream;
import java.io.PrintWriter;

public class Logger {
    public static final String[] LEVELS = new String[]{"none", "debug", "info", "warn", "error"};
    public static final int NONE = 0;
    public static final int DEBUG = 1;
    public static final int INFO = 2;
    public static final int WARN = 3;
    public static final int ERROR = 4;
    private PrintWriter out;
    private Object source;

    public Logger(Object source) {
        this.out = new PrintWriter(System.err);
        this.source = source;
    }

    public Logger(PrintWriter out, Object source) {
        this.out = out;
        this.source = source;
    }

    public Logger(PrintStream out, Object source) {
        this(new PrintWriter(out), source);
    }

    public PrintWriter logWriter() {
        return this.out;
    }

    public void debug(String message) {
        this.log(1, message, null);
    }

    public void info(String message) {
        this.log(2, message, null);
    }

    public void warn(String message) {
        this.log(3, message, null);
    }

    public void error(String message) {
        this.log(4, message, null);
    }

    public void debug(String message, Throwable error) {
        this.log(1, message, error);
    }

    public void info(String message, Throwable error) {
        this.log(2, message, error);
    }

    public void warn(String message, Throwable error) {
        this.log(3, message, error);
    }

    public void error(String message, Throwable error) {
        this.log(4, message, error);
    }

    public synchronized void log(int level, String message, Throwable error) {
        if (level != 0) {
            this.out.print(this.levelString(level) + "\t");
        }
        if (this.source != null) {
            this.out.print(this.sourceString(this.source) + "\t");
        }
        if (message != null) {
            this.out.print(message);
        }
        if (level != 0 || this.source != null || message != null) {
            this.out.println("");
        }
        if (error != null) {
            error.printStackTrace(this.out);
        }
        this.out.flush();
    }

    private String levelString(int level) {
        return LEVELS[level];
    }

    private String sourceString(Object source) {
        if (source == null) {
            return "<null>";
        }
        if (source instanceof Class) {
            return ((Class)source).getName();
        }
        return source.toString();
    }
}

