/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util.json;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.psammead.util.json.JSONMapper;
import net.psammead.util.json.JSONMappingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JSONEncoder {
    private Map<Class<?>, JSONMapper> mappers = new IdentityHashMap();

    public static String encode(Object o) {
        return new JSONEncoder().json(o);
    }

    public void register(Class<?> type, JSONMapper mapper) {
        this.mappers.put(type, mapper);
    }

    public String json(Object o) {
        if (o == null) {
            return "null";
        }
        Class<?> type = o.getClass();
        JSONMapper mapper = this.mappers.get(type);
        if (mapper != null) {
            return this.json(mapper.map(o));
        }
        if (o instanceof Boolean) {
            return o.toString();
        }
        if (o instanceof Number) {
            return o.toString();
        }
        if (o instanceof String) {
            return this.stringLiteral((String)o);
        }
        if (o instanceof List) {
            return this.jsonList((List)o);
        }
        if (o instanceof Map) {
            return this.jsonMap((Map)o);
        }
        throw new JSONMappingException("cannot JSONify type: " + type.getName());
    }

    private String jsonList(List<?> elements) {
        StringBuilder out = new StringBuilder();
        for (Object element : elements) {
            out.append(this.json(element));
            out.append(",\n");
        }
        if (elements.size() != 0) {
            out.setLength(out.length() - ",\n".length());
            out.append("\n");
        }
        return "[\n" + this.indent(out.toString()) + "]";
    }

    private String jsonMap(Map<?, ?> elements) {
        StringBuilder out = new StringBuilder();
        for (Object key : elements.keySet()) {
            out.append(this.json(key));
            out.append(": ");
            out.append(this.json(elements.get(key)));
            out.append(",\n");
        }
        if (elements.size() != 0) {
            out.setLength(out.length() - ",\n".length());
            out.append("\n");
        }
        return "{\n" + this.indent(out.toString()) + "}";
    }

    private String indent(String s) {
        return s.replaceAll("(?m)^", "  ");
    }

    public String stringLiteral(String s) {
        char[] in = s.toCharArray();
        StringBuilder out = new StringBuilder();
        out.append('\"');
        block9: for (int i = 0; i < in.length; ++i) {
            char c = in[i];
            switch (c) {
                case '\"': {
                    out.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    out.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    out.append("\\b");
                    continue block9;
                }
                case '\f': {
                    out.append("\\f");
                    continue block9;
                }
                case '\n': {
                    out.append("\\n");
                    continue block9;
                }
                case '\r': {
                    out.append("\\r");
                    continue block9;
                }
                case '\t': {
                    out.append("\\t");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        out.append("\\u");
                        String hex = Integer.toHexString(c);
                        for (int j = hex.length(); j < 4; ++j) {
                            out.append('0');
                        }
                        out.append(hex);
                        continue block9;
                    }
                    out.append(c);
                }
            }
        }
        out.append('\"');
        return out.toString();
    }
}

