package net.psammead.util;

/** static utility class to encode XML entities */
public final class XMLCodec {
	/** function collection, shall not be instantiated */
	private XMLCodec() {}
	
	/** encode minimum XML entities suitable for a tag body */
	public static String encodeBody(String s) {	
		StringBuilder	out	= new StringBuilder();
		int				len	= s.length();
		for (int i=0; i<len; i++) {
			char c = s.charAt(i);
			switch (c) {
				case '&':	out.append("&amp;");	break;
				case '<':	out.append("&lt;");		break;
				case '>':	out.append("&gt;");		break;
				default:	out.append(c);
			}
		}
		return out.toString();
	}
	
	/** decode minimum XML entities suitable for use in a tag body */
	public static String decodeBody(String s) throws IllegalArgumentException {
		Scan			tok	= new Scan(s);
		StringBuilder	out	= new StringBuilder();
		for (;;) {
			if (tok.isFinished())		break;
										out.append(tok.scan("&"));
			if (tok.isFinished())		break;
				 if (tok.is("&amp;"))	out.append('&');
			else if (tok.is("&lt;"))	out.append('<'); 
			else if (tok.is("&gt;"))	out.append('>'); 
			else if (tok.is("&"))		out.append('&');
		}
		return out.toString();
	}
	
	//------------------------------------------------------------------------------

	// TODO needs two different versions, one with &apos; one with &quot; right?
	
	/** encode minimum XML entities suitable for use in an attribute */
	public static String encodeAttribute(String s) {	
		StringBuilder	out	= new StringBuilder();
		int				len	= s.length();
		for (int i=0; i<len; i++) {
			char c = s.charAt(i);
			switch (c) {
				case '&':	out.append("&amp;");	break;
				case '<':	out.append("&lt;");		break;
				case '>':	out.append("&gt;");		break;
				case '"':	out.append("&quot;");	break;
				//case '\'':	out.append("&apos;");	break; 
				default:	out.append(c);
			}
		}
		return out.toString();
	}
	
	/** decode minimum XML entities suitable for use in an atttribute */
	public static String decodeAttribute(String s) throws IllegalArgumentException {
		Scan			tok	= new Scan(s);
		StringBuilder	out	= new StringBuilder();
		for (;;) {
			if (tok.isFinished())		break;
										out.append(tok.scan("&"));
			if (tok.isFinished())		break;
				 if (tok.is("&quot;"))	out.append('\"'); 
			//else if (tok.is("&apos;"))	out.append('\'');
			else if (tok.is("&amp;"))	out.append('&');
			else if (tok.is("&lt;"))	out.append('<'); 
			else if (tok.is("&gt;"))	out.append('>'); 
			else if (tok.is("&"))		out.append('&');
		}
		return out.toString();
	}

	//------------------------------------------------------------------------------

	/*
	public static void decodeBody(String s) {
		return s.replaceAll("&quot;", "\"")
				.replaceAll("&apos;", "'")
				.replaceAll("&lt;", "<")
				.replaceAll("&gt;", ">")
				.replaceAll("&amp;", "&");
	}

	public static void decodeAttribute(String s) {
		return s.replaceAll("&quot;", "\"")
				.replaceAll("&apos;", "'")
				.replaceAll("&lt;", "<")
				.replaceAll("&gt;", ">")
				.replaceAll("&amp;", "&");
	}
	*/
}
