package net.psammead.commonist.task;

import java.io.*;
import java.util.*;

import javax.swing.*;

import net.psammead.commonist.*;
import net.psammead.commonist.thumb.*;
import net.psammead.commonist.ui.*;
import net.psammead.commonist.util.*;
import net.psammead.util.*;

/** change the directory displayed in the ImageListUI */
public class ChangeDirectoryTask extends Task {
	private static final Logger log = new Logger(ChangeDirectoryTask.class);
	
	private MainWindow			mainWindow;
	private ImageListUILater	imageListUILater;
	private StatusUILater		statusUILater;
	private Thumbnails			thumbnails;
	private	File				directory;
	
	public ChangeDirectoryTask(MainWindow mainWindow, ImageListUI imageListUI, StatusUI statusUI, Thumbnails thumbnails,  File directory) {
		this.mainWindow			= mainWindow;
		this.imageListUILater	= new ImageListUILater(imageListUI);
		this.statusUILater		= new StatusUILater(statusUI);
		this.thumbnails			= thumbnails;
		this.directory			= directory;
	}
	
	protected void execute() {
		log.debug("clear");
		
		imageListUILater.clear();
		Thread.yield();	//Thread.sleep(50);
		
		log.debug("listFiles"); 
		File[]	files	= directory.listFiles(FileFilters.FILES_ONLY);
		if (files == null) { log.warn("directory does not exist: " + directory); return; }
		Arrays.sort(files);	// use a Comparator?
		
		int 	cur		= 0;
		int 	max		= files.length;
		long	last	= 0;
		try {
			for (int i=0; i<files.length; i++) {
				check();
				
				File	file	= files[i];
	
//				log.debug("loading: " + file.getName()); 
				statusUILater.determinate("imageList.loading", new Object[] {file.getPath(), new Integer(cur), new Integer(max) }, cur, max);
				cur++;
	
				if (!file.canRead()) { log.warn("cannot read: " + file); continue; }
				// using Thread.interrupt while this is running kills the EDT??
				Icon	thumbnail	= thumbnails.thumbnail(file);
				imageListUILater.add(file, thumbnail);
				try { Thread.sleep(100); }
				catch (InterruptedException e) { log.warn("interrupted", e); break; }
	
				// update when a given number of ImageUIs have been added
				// or a given delay has elapsed or 
				long	now	= System.currentTimeMillis();
				if (now - last > Constants.IMAGELIST_UPDATE_DELAY
				|| (cur % Constants.IMAGELIST_UPDATE_COUNT) == 0) {
					imageListUILater.updateSelectStatus();
					// this doesn't have to run in the EDT, 
					// but is needed to make our changes visible
					mainWindow.revalidate();
					last	= now;
				}
			}
			
			statusUILater.halt("imageList.loaded", new Object[] { directory.getPath(), new Integer(max) });
		}
		catch (AbortedException e) {
			log.info("loading image list aborted");
			// TODO: statusUI?
		}
		imageListUILater.updateSelectStatus();
	}
}
