package net.psammead.commonist.ui;

import javax.swing.*;

import net.psammead.commonist.*;
import net.psammead.commonist.util.*;

/** a JProgressBar displaying Messages */
public final class StatusUI implements UI {
	// components
	private JProgressBar	progressBar;
	
	/** displays program status */
	public StatusUI() {
		progressBar	= new JProgressBar(JProgressBar.HORIZONTAL);
		progressBar.setStringPainted(true);
	}
	
	/** UI: returns the JComponent this UI controls */
	public JComponent getComponent() {
		return progressBar;
	}
	
	/** changes the upload progressbar to indeterminate state */
	public void indeterminate(String messageKey, Object[] data) {
		progressBar.setIndeterminate(true);
		progressBar.setString(Messages.message(messageKey, data));
	}
	
	/** changes the upload progressbar to determinate state */
	public void determinate(String messageKey, Object[] data, int value, int maximum) {
		progressBar.setIndeterminate(false);
		progressBar.setString(Messages.message(messageKey, data));
		progressBar.setMaximum(maximum);
		progressBar.setValue(value);
	}
	
	/** changes the upload progressbar to determinate state */
	public void halt(String messageKey, Object[] data) {
		progressBar.setIndeterminate(false);
		progressBar.setString(Messages.message(messageKey, data));
		progressBar.setMaximum(0);
		progressBar.setValue(0);
	}
}
