package net.psammead.commonist.ui;

import java.awt.event.*;

import javax.swing.*;

import net.psammead.commonist.*;
import net.psammead.commonist.util.*;
import net.psammead.util.ui.*;

public class UploadUI implements UI {
	/** action events this UI sends */
	public interface Callback {
		void startUpload();
		void stopUpload();
	}
	
	// components
	private JPanel	panel;

	/** displays upload status and starts and stops uploading */
	public UploadUI(final Callback callback) {
		JButton	uploadButton	= new JButton(Messages.text("upload.upload"));
		JButton	abortButton		= new JButton(Messages.text("upload.abort"));
		
		panel	= new GridBagPanel();
		panel.add(abortButton,	"at 0/0 size 1/1 weight 1/0 fill horizontal");
		panel.add(uploadButton,	"at 1/0 size 1/1 weight 1/0 fill horizontal");
		
		uploadButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ev) {
				callback.startUpload();
			}
		});
		
		abortButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ev) {
				callback.stopUpload();
			}
		});
	}
	
	/** UI: returns the JComponent this UI controls */
	public JComponent getComponent() {
		return panel;
	}
}
