package net.psammead.mwapi.yurik.json.hack;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.psammead.mwapi.yurik.json.JSONConverter;
import net.psammead.mwapi.yurik.json.JSONConverterContext;
import net.psammead.mwapi.yurik.json.JSONConverterException;

public class FilteredMapValuesIter implements JSONConverter {
	private final JSONConverter	sub;
	private final String		keyRegexp;
	
	public FilteredMapValuesIter(String keyRegexp, JSONConverter sub) {
		this.sub		= sub;
		this.keyRegexp	= keyRegexp;
	}
	
	@SuppressWarnings("unchecked")
	public Object convert(JSONConverterContext ctx, Object o) throws JSONConverterException {
		if (!(o instanceof Map))	throw new JSONConverterException("expected a List: " + o);
		Map data	= (Map)o;
		
		List out	= new ArrayList();
		Set<String>	keys	= data.keySet();
		for (String key : keys) {
			if (!key.matches(keyRegexp))	continue;
			Object	raw		= data.get(key);
			Object	mangled	= sub.convert(ctx, raw);
			out.add(mangled);
		}
		return out;
	}
}
