package net.psammead.util.ui;

import java.awt.*;

import javax.swing.*;

/** a JPanel specialized on layouting with GridBagUtils */
public class GridBagPanel extends JPanel {
	/** initializes with a GridBagLayout */
	public GridBagPanel() {
		super(new GridBagLayout(), true);
	}
	
	@Override
	public void setLayout(LayoutManager layout) {
		if (!(layout instanceof GridBagLayout))
				throw new IllegalStateException("manually setting a LayoutManager on a GridBagPanel is not allowed");
		super.setLayout(layout);
	}
	
	/** adds parsing a String into GridBagConstrains with GridBagUtil */
	@Override
	public void add(Component component, Object constraints) {
		if (constraints instanceof String) {
			add(component, GridBagUtil.constraints((String) constraints));
		}
		else {
			super.add(component, constraints);
		}
	}
}
