package net.psammead.mwapi.yurik.json;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MapValuesIter implements JSONConverter {
	private final JSONConverter	sub;
	
	public MapValuesIter(JSONConverter sub) {
		this.sub = sub;
	}
	
	@SuppressWarnings("unchecked")
	public Object convert(JSONConverterContext ctx, Object o) throws JSONConverterException {
		if (!(o instanceof Map))	throw new JSONConverterException("expected a List: " + o);
		Map data	= (Map)o;
		
		List out	= new ArrayList();
		for (Object i : data.values()) {
			out.add(sub.convert(ctx, i));
		}
		return out;
	}
}
