/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.mwapi;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MediaWikiException
extends Exception {
    private List<Factoid> factoids = new ArrayList<Factoid>();

    public MediaWikiException(String message) {
        super(message);
    }

    public MediaWikiException(String message, Throwable cause) {
        super(message, cause);
    }

    public MediaWikiException addFactoid(String name, Object value) {
        this.factoids.add(new Factoid(name, value));
        return this;
    }

    public List<Object> getFactoids() {
        return new ArrayList<Object>(this.factoids);
    }

    @Override
    public String getMessage() {
        StringBuffer out = new StringBuffer(super.getMessage());
        for (Factoid factoid : this.factoids) {
            out.append('\n').append(factoid.name).append('\t').append(factoid.value != null ? String.valueOf(factoid.value) : "<null>");
        }
        return out.toString();
    }

    public static class Factoid {
        public final String name;
        public final Object value;

        public Factoid(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

