/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.mwapi.connection;

import net.psammead.mwapi.Location;
import net.psammead.mwapi.NameSpace;
import net.psammead.mwapi.config.Family;
import net.psammead.mwapi.config.Site;
import net.psammead.mwapi.connection.ConfigManager;
import net.psammead.mwapi.connection.TitleUtil;
import net.psammead.mwapi.ui.UnsupportedWikiException;

public class LocationManager {
    private ConfigManager configManager;

    public LocationManager(ConfigManager siteManager) {
        this.configManager = siteManager;
    }

    public Location absoluteLocation(String link) throws UnsupportedWikiException {
        String wiki;
        int pos = (link = TitleUtil.underscores(link)).indexOf(58);
        if (pos == -1) {
            return null;
        }
        String familyName = link.substring(0, pos);
        link = link.substring(pos + 1);
        Family family = this.configManager.getFamily(familyName);
        if (family == null) {
            throw new UnsupportedWikiException("family unknown: " + link);
        }
        if (family.multilingual) {
            pos = link.indexOf(58);
            if (pos == -1) {
                throw new UnsupportedWikiException("language missing: " + link);
            }
            String siteLanguage = link.substring(0, pos);
            link = link.substring(pos + 1);
            wiki = TitleUtil.buildWiki(family.name, siteLanguage);
        } else {
            String siteLanguage = family.defaultLanguage;
            wiki = TitleUtil.buildWiki(family.name, siteLanguage);
        }
        return new Location(wiki, link);
    }

    public Location relativeLocation(Location baseLocation, String link) throws UnsupportedWikiException {
        Site site;
        String wiki;
        if ((link = TitleUtil.underscores(link)).startsWith("/")) {
            return new Location(baseLocation.wiki, baseLocation.title + link);
        }
        if (link.startsWith(":")) {
            link = link.substring(1);
        }
        Site baseSite = this.configManager.getSite(baseLocation.wiki);
        String familyName = wiki = baseLocation.wiki;
        String siteLanguage = null;
        int pos = wiki.indexOf(58);
        if (pos != -1) {
            familyName = wiki.substring(0, pos);
            siteLanguage = wiki.substring(pos + 1);
        }
        if ((pos = link.indexOf(58)) == -1) {
            return new Location(wiki, link);
        }
        String maybe = link.substring(0, pos);
        Family family = this.configManager.getFamily(maybe);
        NameSpace projectNS = baseSite.nameSpace(4);
        if (family != null && !projectNS.matches(link) && maybe.toLowerCase().equals(maybe)) {
            familyName = family.name;
            if (maybe.equalsIgnoreCase(family.name)) {
                siteLanguage = family.defaultLanguage;
            } else if (!family.multilingual) {
                siteLanguage = family.defaultLanguage;
            } else if (siteLanguage == null) {
                siteLanguage = family.defaultLanguage;
            }
            link = link.substring(pos + 1);
        } else {
            family = this.configManager.getFamily(familyName);
            familyName = family.name;
        }
        pos = link.indexOf(58);
        if (pos != -1 && (site = this.configManager.getSite(family, maybe = link.substring(0, pos))) != null) {
            siteLanguage = maybe.toLowerCase();
            link = link.substring(pos + 1);
        }
        if (family.multilingual && siteLanguage != null && !family.supportedLanguages.contains(siteLanguage.toLowerCase())) {
            siteLanguage = family.defaultLanguage;
        }
        wiki = familyName;
        if (siteLanguage != null) {
            wiki = wiki + ":" + siteLanguage;
        }
        return new Location(wiki, link);
    }

    public Location regularPageFor(Location location) throws UnsupportedWikiException {
        String wiki = location.wiki;
        String title = location.title;
        Site site = this.configManager.getSite(wiki);
        NameSpace oldNS = site.nameSpaceForTitle(title);
        if (oldNS.isRegular()) {
            return null;
        }
        NameSpace newNS = oldNS.toggleDiscussion();
        if (newNS == null) {
            return null;
        }
        return new Location(wiki, this.changeNameSpace(title, oldNS, newNS));
    }

    public Location discussionPageFor(Location location) throws UnsupportedWikiException {
        String wiki = location.wiki;
        String title = location.title;
        Site site = this.configManager.getSite(wiki);
        NameSpace oldNS = site.nameSpaceForTitle(title);
        if (oldNS.isDiscussion()) {
            return null;
        }
        NameSpace newNS = oldNS.toggleDiscussion();
        if (newNS == null) {
            return null;
        }
        return new Location(wiki, this.changeNameSpace(title, oldNS, newNS));
    }

    public Location toggleDiscussion(Location location) throws UnsupportedWikiException {
        String wiki = location.wiki;
        String title = location.title;
        Site site = this.configManager.getSite(wiki);
        NameSpace oldNS = site.nameSpaceForTitle(title);
        NameSpace newNS = oldNS.toggleDiscussion();
        if (newNS == null) {
            return null;
        }
        return new Location(wiki, this.changeNameSpace(title, oldNS, newNS));
    }

    public String changeNameSpace(String title, NameSpace sourceNS, NameSpace targetNS) {
        title = sourceNS.removeFrom(title);
        title = targetNS.addTo(title);
        return title;
    }
}

