/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.mwapi.yurik;

import java.io.File;
import java.io.IOException;
import net.psammead.mwapi.yurik.YurikAPI;
import net.psammead.mwapi.yurik.json.JSONConverterContext;
import net.psammead.mwapi.yurik.json.JSONConverterException;
import net.psammead.util.IOUtil;
import net.psammead.util.json.JSONDecodeException;
import net.psammead.util.json.JSONDecoder;

public class JSONConverterTest {
    private static JSONConverterContext ctx = new JSONConverterContext("wikipedia:de");

    public static void main(String[] args) throws IOException, JSONConverterException, JSONDecodeException {
        JSONConverterTest.testError();
        JSONConverterTest.testProp();
        JSONConverterTest.testList();
    }

    private static Object loadJSON(String path) throws JSONDecodeException, IOException {
        return JSONDecoder.decode((String)IOUtil.readStringFromFile((File)new File("/home/daniel/Project/current/mwapi/test/data/" + path), (String)"ISO-8859-1"));
    }

    private static void testError() throws JSONDecodeException, IOException, JSONConverterException {
        System.out.println(YurikAPI.ERROR_CONVERTER.convert(ctx, JSONConverterTest.loadJSON("error.js")));
    }

    private static void testProp() throws JSONDecodeException, IOException, JSONConverterException {
        System.out.println(YurikAPI.CATEGORIES_CONVERTER.convert(ctx, JSONConverterTest.loadJSON("prop/categories.js")));
        System.out.println(YurikAPI.EXTLINKS_CONVERTER.convert(ctx, JSONConverterTest.loadJSON("prop/extlinks.js")));
        System.out.println(YurikAPI.IMAGEINFO_CONVERTER.convert(ctx, JSONConverterTest.loadJSON("prop/imageinfo.js")));
        System.out.println(YurikAPI.IMAGES_CONVERTER.convert(ctx, JSONConverterTest.loadJSON("prop/images.js")));
        System.out.println(YurikAPI.INFO_CONVERTER.convert(ctx, JSONConverterTest.loadJSON("prop/info.js")));
        System.out.println(YurikAPI.LANGLINKS_CONVERTER.convert(ctx, JSONConverterTest.loadJSON("prop/langlinks.js")));
        System.out.println(YurikAPI.LINKS_CONVERTER.convert(ctx, JSONConverterTest.loadJSON("prop/links.js")));
        System.out.println(YurikAPI.REVISIONS_CONVERTER.convert(ctx, JSONConverterTest.loadJSON("prop/revisions.js")));
        System.out.println(YurikAPI.TEMPLATES_CONVERTER.convert(ctx, JSONConverterTest.loadJSON("prop/templates.js")));
        System.out.println(YurikAPI.IMAGES_CONVERTER.convert(ctx, JSONConverterTest.loadJSON("prop/images2.js")));
    }

    private static void testList() throws JSONConverterException, JSONDecodeException, IOException {
        System.out.println(YurikAPI.ALLPAGES_CONVERTER.convert(ctx, JSONConverterTest.loadJSON("list/allpages.js")));
        System.out.println(YurikAPI.ALLLINKS_CONVERTER.convert(ctx, JSONConverterTest.loadJSON("list/alllinks.js")));
        System.out.println(YurikAPI.ALLUSERS_CONVERTER.convert(ctx, JSONConverterTest.loadJSON("list/allusers.js")));
        System.out.println(YurikAPI.BACKLINKS_CONVERTER.convert(ctx, JSONConverterTest.loadJSON("list/backlinks.js")));
        System.out.println(YurikAPI.CATEGORYMEMBERS_CONVERTER.convert(ctx, JSONConverterTest.loadJSON("list/categorymembers.js")));
        System.out.println(YurikAPI.EMBEDDEDIN_CONVERTER.convert(ctx, JSONConverterTest.loadJSON("list/embeddedin.js")));
        System.out.println(YurikAPI.EXTURLUSAGE_CONVERTER.convert(ctx, JSONConverterTest.loadJSON("list/exturlusage.js")));
        System.out.println(YurikAPI.IMAGEUSAGE_CONVERTER.convert(ctx, JSONConverterTest.loadJSON("list/imageusage.js")));
        System.out.println(YurikAPI.LOGEVENTS_CONVERTER.convert(ctx, JSONConverterTest.loadJSON("list/logevents.js")));
        System.out.println(YurikAPI.RECENTCHANGES_CONVERTER.convert(ctx, JSONConverterTest.loadJSON("list/recentchanges.js")));
        System.out.println(YurikAPI.USERCONTRIBS_CONVERTER.convert(ctx, JSONConverterTest.loadJSON("list/usercontribs.js")));
        System.out.println(YurikAPI.WATCHLIST_CONVERTER.convert(ctx, JSONConverterTest.loadJSON("list/watchlist.js")));
    }
}

