/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util;

import java.util.ArrayList;
import net.psammead.util.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Filters {
    private Filters() {
    }

    public static <VALUE> Filter[] array(Iterable<Filter<VALUE>> filters) {
        ArrayList<Filter<VALUE>> tmp = new ArrayList<Filter<VALUE>>();
        for (Filter<VALUE> filter : filters) {
            tmp.add(filter);
        }
        return tmp.toArray(new Filter[0]);
    }

    public static <VALUE> Filter<VALUE> all() {
        return new Filter<VALUE>(){

            @Override
            public boolean accept(VALUE element) {
                return true;
            }
        };
    }

    public static <VALUE> Filter<VALUE> none() {
        return new Filter<VALUE>(){

            @Override
            public boolean accept(VALUE element) {
                return false;
            }
        };
    }

    public static <VALUE> Filter<VALUE> not(final Filter<VALUE> sub) {
        return new Filter<VALUE>(){

            @Override
            public boolean accept(VALUE element) {
                return !sub.accept(element);
            }
        };
    }

    public static <VALUE> Filter<VALUE> and(final Filter<VALUE> ... subs) {
        return new Filter<VALUE>(){

            @Override
            public boolean accept(VALUE element) {
                for (Filter sub : subs) {
                    if (sub.accept(element)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <VALUE> Filter<VALUE> or(final Filter<VALUE> ... subs) {
        return new Filter<VALUE>(){

            @Override
            public boolean accept(VALUE element) {
                for (Filter sub : subs) {
                    if (!sub.accept(element)) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

