/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util;

import java.util.Iterator;
import net.psammead.util.ToString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LongRange
implements Iterable<Long> {
    public final long start;
    public final long end;
    public final long size;
    public final boolean forward;

    public static final LongRange range(long start, long end) {
        return new LongRange(start, end);
    }

    public LongRange(long start, long end) {
        this.start = start;
        this.end = end;
        this.forward = end >= start;
        this.size = end - start;
    }

    public boolean contains(long value) {
        return this.forward ? value >= this.start && value < this.end : value <= this.start && value > this.end;
    }

    @Override
    public Iterator<Long> iterator() {
        return new RangeIterator();
    }

    public String toString() {
        return new ToString(this).append("start", this.start).append("end", this.end).toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.end ^ this.end >>> 32);
        result = 31 * result + (this.forward ? 1231 : 1237);
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (int)(this.start ^ this.start >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LongRange other = (LongRange)obj;
        if (this.end != other.end) {
            return false;
        }
        if (this.forward != other.forward) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        return this.start == other.start;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RangeIterator
    implements Iterator<Long> {
        private long value;

        public RangeIterator() {
            this.value = LongRange.this.start;
        }

        @Override
        public boolean hasNext() {
            return LongRange.this.forward ? this.value < LongRange.this.end : this.value > LongRange.this.end;
        }

        @Override
        public Long next() {
            long out = this.value;
            this.value += LongRange.this.forward ? 1L : -1L;
            return out;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

