/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.psammead.util.DebugUtil;
import net.psammead.util.JavaLiteral;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ToString {
    private final Object object;
    private final List<Part> parts;
    private static final String NULL_LITERAL = "<null>";
    private static final String SEPARATOR = ", ";

    public ToString(Object object) {
        this.object = object;
        this.parts = new ArrayList<Part>();
    }

    public ToString append(String name, Object value) {
        this.parts.add(new Part(name, value));
        return this;
    }

    public ToString appendField(String name) {
        Field[] classFields;
        Class<?> objectClass = this.object.getClass();
        for (Field field : classFields = objectClass.getFields()) {
            if (!field.getName().equals(name)) continue;
            if (!Modifier.isPublic(field.getModifiers())) {
                throw new IllegalArgumentException("field is not public: " + name + " in class: " + objectClass.getName());
            }
            try {
                Object value = field.get(this.object);
                this.append(name, value);
                return this;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("field not accessible: " + name + " in class: " + objectClass.getName(), e);
            }
        }
        throw new IllegalArgumentException("field does not exist: " + name + " in class: " + objectClass.getName());
    }

    public String toString() {
        if (this.object == null) {
            return NULL_LITERAL;
        }
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (Part part : this.parts) {
            if (first) {
                first = false;
            } else {
                b.append(SEPARATOR);
            }
            b.append(part.toString());
        }
        return DebugUtil.shortClassName(this.object) + "{ " + b.toString() + " }";
    }

    public static String stringifyAny(Object value) {
        if (value == null) {
            return NULL_LITERAL;
        }
        if (value instanceof Map) {
            return ToString.stringifyMap((Map)value);
        }
        if (value instanceof Map.Entry) {
            return ToString.stringifyMapEntry((Map.Entry)value);
        }
        if (value instanceof Iterable) {
            return ToString.stringifyIterable((Iterable)value);
        }
        if (value instanceof Object[]) {
            return ToString.stringifyArray((Object[])value);
        }
        if (value instanceof byte[]) {
            return Arrays.toString((byte[])value);
        }
        if (value instanceof short[]) {
            return Arrays.toString((short[])value);
        }
        if (value instanceof int[]) {
            return Arrays.toString((int[])value);
        }
        if (value instanceof long[]) {
            return Arrays.toString((long[])value);
        }
        if (value instanceof boolean[]) {
            return Arrays.toString((boolean[])value);
        }
        if (value instanceof char[]) {
            return Arrays.toString((char[])value);
        }
        if (value instanceof float[]) {
            return Arrays.toString((float[])value);
        }
        if (value instanceof double[]) {
            return Arrays.toString((double[])value);
        }
        if (value instanceof Enum) {
            return ToString.stringifyEnum((Enum)value);
        }
        if (value instanceof String) {
            return JavaLiteral.encodeString((String)value);
        }
        if (value instanceof Character) {
            return JavaLiteral.encodeChar(((Character)value).charValue());
        }
        return value.toString();
    }

    private static String stringifyMap(Map<?, ?> map) {
        return DebugUtil.shortClassName(map) + "[ " + ToString.stringifyInner(map.entrySet()) + " ]";
    }

    private static String stringifyMapEntry(Map.Entry<?, ?> mapEntry) {
        return ToString.stringifyAny(mapEntry.getKey()) + " => " + ToString.stringifyAny(mapEntry.getValue());
    }

    private static String stringifyIterable(Iterable<?> iterable) {
        return DebugUtil.shortClassName(iterable) + "[ " + ToString.stringifyInner(iterable) + " ]";
    }

    private static String stringifyArray(Object[] array) {
        return DebugUtil.shortClassName(array) + "[ " + ToString.stringifyInner(Arrays.asList(array)) + " ]";
    }

    private static String stringifyEnum(Enum<?> enum_) {
        return DebugUtil.shortClassName(enum_) + "{ name=" + enum_.toString() + " }";
    }

    private static String stringifyInner(Iterable<?> iterable) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (Object element : iterable) {
            if (first) {
                first = false;
            } else {
                b.append(SEPARATOR);
            }
            b.append(ToString.stringifyAny(element));
        }
        return b.toString();
    }

    private static class Part {
        public final String name;
        public final Object value;

        public Part(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return this.name + "=" + ToString.stringifyAny(this.value);
        }
    }
}

