package net.psammead.util;

public final class Transformers {
	private Transformers() {}
	
	public static <S,T> Transformer<S,T> nullify() {
		return new Transformer<S,T>() {
			public T transform(S source) {
				return null;
			}
		};
	}
	
	public static <S> Transformer<S,String> stringify() {
		return new Transformer<S,String>() {
			public String transform(S source) {
				return source != null ? source.toString() : null;
			}
		};
	}
	
	public static <R,S,T> Transformer<R,T> chain(final Transformer<R,S> first, final Transformer<S,T> second) {
		return new Transformer<R,T>() {
			public T transform(R source) {
				return second.transform(first.transform(source));
			}
		};
	}
}
