package net.psammead.util.ui;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;

import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.WindowConstants;

public final class UIUtil {
	/** display a {@link JComponent} in a {@link JFrame} and exit the application when closed */
	public static void framed(JComponent component) {
		framed(component, true, true);
	}
	
	/** display a {@link JComponent} in a {@link JFrame} */
	public static void framed(JComponent component, boolean exitOnClose, boolean closeOnEscape) {
		JFrame frame	= new JFrame();
		frame.setDefaultCloseOperation(exitOnClose
				? JFrame.EXIT_ON_CLOSE
				: WindowConstants.DISPOSE_ON_CLOSE);
		frame.setSize(800, 600);
		frame.setLocationRelativeTo(null);
		
		Container content = frame.getContentPane();
		content.setLayout(new BorderLayout());
		content.add(component, BorderLayout.CENTER);
		
		frame.setVisible(true);
		
		if (closeOnEscape)	disposeOnEscape(frame);
	}
	
	/** make a {@link RootPaneContainer} which is a {@link Window} dispose itself when the user presses gthe ESC key */
	public static void disposeOnEscape(RootPaneContainer container) {
		if (!(container instanceof Window))	return;
		final Window window	= (Window)container; 
		container.getRootPane().registerKeyboardAction(
				new ActionListener() { public void actionPerformed(ActionEvent ev) {
					window.dispose();
				}},
				KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0),
				JComponent.WHEN_IN_FOCUSED_WINDOW
			);
	}
	
	public static void edtWait(Runnable runnable) {
		if (SwingUtilities.isEventDispatchThread()) { runnable.run(); return; }
		try { SwingUtilities.invokeAndWait(runnable); }
		catch (Exception e) { throw new RuntimeException(e); }
	}
	
	public static void edtRun(Runnable runnable) {
		if (SwingUtilities.isEventDispatchThread()) { runnable.run(); return; }
		try { SwingUtilities.invokeLater(runnable); }
		catch (Exception e) { throw new RuntimeException(e); }
	}
}
