package net.psammead.mwapi.ui.action;

import java.io.*;
import java.net.*;
import java.util.*;
import java.util.regex.Pattern;

import net.psammead.mwapi.*;
import net.psammead.mwapi.connection.Connection;
import net.psammead.mwapi.net.*;
import net.psammead.mwapi.ui.MethodException;
import net.psammead.mwapi.ui.UnexpectedAnswerException;
import net.psammead.mwapi.ui.action.response.*;

import org.apache.commons.httpclient.*;

import au.id.jericho.lib.html.*;

/** base class for complex actions which load a form, modify its values, and store it */
public abstract class UiFormActionBase extends UiActionBase {
	private String				fetchTitle;
	private	Map<String,String>	fetchArgs;
	
	// form selector
	private String	formName;
	private String	formId;
	private int		formIndex;
	
	private Set<String>			copyArgs;
	private	Map<String,String>	actionArgs;
	private ResponseSelect		responseSelect;
	
	protected UiFormActionBase(MediaWiki mediaWiki, Connection connection) {
		super(mediaWiki, connection);
		fetchTitle		= null;
		fetchArgs		= new HashMap<String,String>();
		formName		= null;
		formId			= null;
		formIndex		= -1;
		copyArgs		= new HashSet<String>();
		actionArgs		= new HashMap<String,String>();
		responseSelect	= new ResponseSelect();
	}
	
	//-------------------------------------------------------------------------
	//## configuration setter
	
	/** title of the page containing the form */
	protected void fetchTitle(String title) {
		this.fetchTitle	= title;
	}
	
	/** arguments used to fetch the form */
	protected void fetchArg(String name, String value) {
		if (value != null)	fetchArgs.put(name, value);
		else				fetchArgs.remove(name);
	}
	
	/** name of the form */
	protected void formName(String name) {
		this.formName	= name;
	}
	
	/** id of the form, alternative to formName */
	protected void formId(String id) {
		this.formId	= id;
	}
	
	/** index of the form, alternative to formId */
	protected void formIndex(int index) {
		this.formIndex	= index;
	}
	
	/** names of fields to copy from the form into the action parameters */
	protected void copyArg(String name) {
		copyArgs.add(name);
	}
	
	/** arguments for form submission */
	protected void actionArg(String name, String value) {
		if (value != null)	actionArgs.put(name, value);
		else				actionArgs.remove(name);
	}
	
	/** register a handler for a specific response to the form submission */
	protected void responseHandler(int responseCode, ResponseHandler handler) {
		responseSelect.register(new ResponsePattern(responseCode), handler);
	}

	/** register a handler for a message response to the form submission */
	protected void responseMessageHandler(int responseCode, String messageName, ResponseHandler handler) {
		Pattern	regexp	= messageRegexp(messageName);
		if (regexp == null)	throw new IllegalArgumentException("message not available: " + messageName);
		responseSelect.register(new ResponsePattern(responseCode, regexp), handler);
	}
	
	/** register a handler for a message response to the form submission */
	protected void responseLiteralHandler(int responseCode, String literalText, ResponseHandler handler) {
		responseSelect.register(new ResponsePattern(responseCode, literalText), handler);
	}

	//-------------------------------------------------------------------------
	
	/** executes the actions declared in the constructor */
	@Override
	public final void execute() throws MediaWikiException {
		HttpMethod fetchMethod	= null;
		HttpMethod updateMethod	= null;
		try {
			// prepare first method args
			String fetchURL	= urlManager.actionURL(fetchTitle, fetchArgs);
			
			// execute first method
			connection.throttle();
			fetchMethod	= createGetMethod(fetchURL, fetchArgs);
			int			fetchResponseCode	= client.executeMethod(fetchMethod);
			String		fetchResponseBody	= fetchMethod.getResponseBodyAsString();
			// StatusLine	fetchStatusLine		= fetchMethod.getStatusLine();
			debug(fetchMethod);
			if (fetchResponseCode != 200)	throw new UnexpectedAnswerException("unexpected response code (FormAction)");
			
			// prepare second method
			// TODO: use the DataSet jericho provides
			Source		source	= JerichoUtil.createSource(fetchResponseBody, logger);
			Element		form	= JerichoUtil.fetchForm(source, formName, formId, formIndex);
				 
			FormFields	fields		= form.findFormFields();
			for (Iterator<String> it=copyArgs.iterator(); it.hasNext();) {
				String	key		= it.next();
				// TODO: was machen mit leeren boolean-feldern oder submit-feldern, wenn die keine value haben?
				String	value	= JerichoUtil.fetchStringField(fields, key);
				actionArgs.put(key, value);
			}
			// TODO: new URL(fetchURL) is possibly borken
			URL	actionURL	= JerichoUtil.fetchActionURL(new URL(fetchURL), form);
			
			// execute second method
			connection.throttle();
			updateMethod	= createPostMethod(actionURL.toExternalForm(), actionArgs);
			int			updateResponseCode	= client.executeMethod(updateMethod);
			String		updateResponseBody	= updateMethod.getResponseBodyAsString();
			StatusLine	updateStatusLine	= updateMethod.getStatusLine();
			debug(updateMethod);
			
			// handle response of second method
			URL	redirect	= null;
			if (updateResponseCode == 302) {
				redirect	= extractRedirectURL(updateMethod);
			}
			
			boolean	handled	= responseSelect.handle(new ResponseData(
					updateStatusLine, updateResponseBody, redirect, actionURL));
			if (!handled) {	
				logger.debug(updateResponseBody);
				throw new UnexpectedAnswerException("unexpected response data (FormAction)")
								.addFactoid("status", updateStatusLine);
			}
		}
		catch (HttpException		e) { throw new MethodException("method failed", e); }
		catch (IOException			e) { throw new MethodException("method failed", e); }
		catch (InterruptedException	e) { throw new MethodException("method aborted", e); }
		catch (IllegalFormException e) { throw new MethodException("method failed", e); }
		finally { 
			if (fetchMethod != null)	fetchMethod.releaseConnection(); 
			if (updateMethod != null)	updateMethod.releaseConnection(); 
		}
	}
}
