package net.psammead.mwapi.ui.action.parser;

import net.psammead.mwapi.net.*;
import net.psammead.util.*;
import au.id.jericho.lib.html.*;

/**
 * parsed contents of an UploadWarning form 
 * throws a UploadException when something in the form is missing.
 */
public class ParsedUploadWarning {
	public final boolean	ignoreWarning;
	public final String		sessionKey;
	public final String		uploadDescription;
	public final String		destFile;
	public final String		license;
	
	public ParsedUploadWarning(Source source) throws IllegalFormException {
		Element		form	= JerichoUtil.fetchForm(source, "uploadwarning", "uploadwarning", -1);
		FormFields	fields	= form.findFormFields();
		ignoreWarning		= JerichoUtil.fetchBooleanField(fields,	"wpIgnoreWarning");	// contains "1" 
		sessionKey			= JerichoUtil.fetchStringField(fields,	"wpSessionKey");
		uploadDescription	= TextUtil.unixLF(
							  JerichoUtil.fetchStringField(fields,	"wpUploadDescription"));
		destFile			= JerichoUtil.fetchStringField(fields,	"wpDestFile");
		license				= JerichoUtil.fetchStringField(fields,	"wpLicense");
	}
}
