package net.psammead.minibpp;

import java.io.*;

/** 
  * Context for the parser generated by JavaCC<br>
  * Internal bridge between a Compiler and a Parser
  */
public final class Context {
	private PrintWriter	out;
	private String		content;
	private boolean		bol;
	
	public Context(PrintWriter out) {
		this.out	= out;
		content		= null;
		bol			= true;
	}

	public void magic(String s) {
		emit();
		content	= s;
	}

	public void literal(String s) {
		emit();
		content	= Compiler.literal(s);
	}

	public void done() {
		out.print("out.println(");
		if (content != null) {
			out.print(content);
		}
		if (bol) {
			out.println(");");
		}
		else {
			out.println(");}");
		}
		content	= null;
		bol		= true;
	}

	private void emit() {
		if (bol) {
			out.print("{");
			bol	= false;
		}
		if (content != null) {
			out.print("out.print(");
			out.print(content);
			out.print(");");
			content = null;
		}
	}
}