package net.psammead.commonist.text;

import java.util.*;

import net.psammead.commonist.data.*;
import net.psammead.commonist.util.*;

/** manages the content and text of a gallery page */
public class Gallery {
	private	Templates		templates;
	private	CommonData		common;
	private	List<Upload>	uploads;
	
	public Gallery(Templates templates, CommonData common) {
		this.templates	= templates;
		this.common		= common;
		uploads	= new ArrayList<Upload>();
	}
	
	/** returns all Uploads added with the add method */
	public List<Upload> getUploads() {
		return uploads;
	}
	
	/** adds an Upload */
	public void addUpload(Upload upload) {
		uploads.add(upload);
	}
	
	/** whether no uploads are available */
	public boolean isEmpty() {
		return uploads.isEmpty();
	}

	/** sets previous and next properties of all currently known uploads */
	public void chain() {
		Upload	previous	= null;
		for (Iterator<Upload> it=uploads.iterator(); it.hasNext();) {
			Upload	current	= it.next();
			if (previous != null) {
				previous.setNext(current);
			}
			current.setPrevious(previous);
			previous	= current;
		}
	}
	
	/** edit summary for writing a gallery */
	public String gallerySummary() {
		// TODO: add version number
		int	failureCount	= failures().size();
		String	summary	= "commonist upload";
		if (failureCount != 0) {
			summary	+= " (" + failureCount + " errors)";
		}
		return summary;
	}
	
	/** compiles into wikitext */
	public String galleryDescription() throws TemplateException {
		String	template	= "commons".equals(common.wiki)
							? "gallery_commons.bpp"
							: "gallery_default.bpp";
		Map<String,List<Upload>>	data	= new HashMap<String,List<Upload>>();
		data.put("uploads",		uploads);
		data.put("successes",	successes());
		data.put("failures",	failures());
		String	out	=	templates.applyTemplate(template, data); 
		return TextUtil.trimLF(TextUtil.restrictEmptyLines(out));
	}
	
	/** compiles an image description into wikitext */
	public String imageDescription(Upload upload) throws TemplateException {
		String	template	= "commons".equals(common.wiki)
			 				? "image_commons.bpp"
							: "image_default.bpp";
		
		Map<String,Upload>	data	= new HashMap<String,Upload>();
		data.put("upload",	upload);
		String	out	=	templates.applyTemplate(template, data); 
		return TextUtil.trimLF(TextUtil.restrictEmptyLines(out));
	}
	
	/** returns all Uploads without an error */
	private List<Upload> successes() {
		List<Upload>	out	= new ArrayList<Upload>();
		for (Iterator<Upload> it=uploads.iterator(); it.hasNext();) {
			Upload	upload	= it.next();
			if (upload.getError() == null) {
				out.add(upload);
			}
		}
		return out;
	}

	/** returns all Uploads with an error */	
	private List<Upload> failures() {
		List<Upload>	out	= new ArrayList<Upload>();
		for (Iterator<Upload> it=uploads.iterator(); it.hasNext();) {
			Upload	upload	= it.next();
			if (upload.getError() != null) {
				out.add(upload);
			}
		}
		return out;
	}

	//------------------------------------------------------------------------------
	//## synthetic properties
	
	public String getParsedCategories() {
		return new ParsedCategories(common.categories).wikiText;
	}
}