/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.mwapi.ui.action;

import au.id.jericho.lib.html.Source;
import net.psammead.mwapi.Location;
import net.psammead.mwapi.MediaWiki;
import net.psammead.mwapi.MediaWikiException;
import net.psammead.mwapi.connection.Connection;
import net.psammead.mwapi.net.IllegalFormException;
import net.psammead.mwapi.net.JerichoUtil;
import net.psammead.mwapi.ui.EditException;
import net.psammead.mwapi.ui.Page;
import net.psammead.mwapi.ui.action.UiSimpleActionBase;
import net.psammead.mwapi.ui.action.parser.ParsedEditForm;
import net.psammead.mwapi.ui.action.response.ResponseData;
import net.psammead.mwapi.ui.action.response.ResponseHandler;

public class PageLoadAction
extends UiSimpleActionBase {
    private final String title;
    private Page page;

    public PageLoadAction(MediaWiki mediaWiki, Connection connection, String title, String oldid) {
        super(mediaWiki, connection);
        this.title = title;
        this.page = null;
        this.simpleMethod(GET);
        this.simpleTitle(title);
        this.simpleArg("action", "edit");
        if (oldid != null) {
            this.simpleArg("oldid", oldid);
        }
        this.responseHandler(200, new ResponseHandler(){

            public boolean handle(ResponseData data) throws MediaWikiException {
                PageLoadAction.this.handleResponse(data, false);
                return true;
            }
        });
        this.responseHandler(404, new ResponseHandler(){

            public boolean handle(ResponseData data) throws MediaWikiException {
                PageLoadAction.this.handleResponse(data, true);
                return true;
            }
        });
    }

    public Page getPage() {
        return this.page;
    }

    private void handleResponse(ResponseData data, boolean fresh) throws MediaWikiException {
        try {
            Source source = JerichoUtil.createSource(data.responseBody, this.logger);
            ParsedEditForm parsed = new ParsedEditForm(this.urlManager, data.formURL, source);
            this.page = parsed.page(fresh);
        }
        catch (IllegalFormException e) {
            Location errorLocation = this.site.location(this.title);
            throw new EditException("editform not usable, the page may be protected").addFactoid("location", errorLocation);
        }
    }
}

