/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.mwapi.ui.action;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.psammead.mwapi.MediaWiki;
import net.psammead.mwapi.MediaWikiException;
import net.psammead.mwapi.connection.Connection;
import net.psammead.mwapi.ui.MethodException;
import net.psammead.mwapi.ui.UnexpectedAnswerException;
import net.psammead.mwapi.ui.UnsupportedURLException;
import net.psammead.mwapi.ui.action.UiActionBase;
import net.psammead.mwapi.ui.action.response.ResponseData;
import net.psammead.mwapi.ui.action.response.ResponseHandler;
import net.psammead.mwapi.ui.action.response.ResponsePattern;
import net.psammead.mwapi.ui.action.response.ResponseSelect;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.StatusLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UiSimpleActionBase
extends UiActionBase {
    public static final Object GET = "GET";
    public static final Object POST = "POST";
    private Object simpleMethod = GET;
    private String simpleTitle = null;
    private Map<String, String> simpleArgs = new HashMap<String, String>();
    private ResponseSelect responseSelect = new ResponseSelect();

    protected UiSimpleActionBase(MediaWiki mediaWiki, Connection connection) {
        super(mediaWiki, connection);
    }

    protected void simpleMethod(Object method) {
        this.simpleMethod = method;
    }

    protected void simpleTitle(String title) {
        this.simpleTitle = title;
    }

    protected void simpleArg(String name, String value) {
        if (value != null) {
            this.simpleArgs.put(name, value);
        } else {
            this.simpleArgs.remove(name);
        }
    }

    protected void responseHandler(int responseCode, ResponseHandler handler) {
        this.responseSelect.register(new ResponsePattern(responseCode), handler);
    }

    protected void responseMessageHandler(int responseCode, String messageName, ResponseHandler handler) {
        Pattern regexp;
        if ("large-file".equals(messageName) && !this.messageAvailable("large-file")) {
            messageName = "largefile";
        }
        if ((regexp = this.messageRegexp(messageName)) == null) {
            throw new IllegalArgumentException("message not available: " + messageName);
        }
        this.responseSelect.register(new ResponsePattern(responseCode, regexp), handler);
    }

    protected void responseLiteralHandler(String literalText, ResponseHandler handler) {
        this.responseSelect.register(new ResponsePattern(literalText), handler);
    }

    protected HttpMethod createRequest(String url, Map<String, String> args) {
        if (this.simpleMethod == GET) {
            return this.createGetMethod(url, args);
        }
        if (this.simpleMethod == POST) {
            return this.createPostMethod(url, args);
        }
        throw new IllegalArgumentException("only GET or POST allowed for UISimpleAction");
    }

    protected String fetchURL(String fetchTitle, Map<String, String> fetchArgs) throws UnsupportedURLException {
        return this.urlManager.actionURL(fetchTitle, fetchArgs);
    }

    @Override
    public final void execute() throws MediaWikiException {
        HttpMethod method = null;
        try {
            boolean handled;
            String fetchURL = this.fetchURL(this.simpleTitle, this.simpleArgs);
            this.connection.throttle();
            method = this.createRequest(fetchURL, this.simpleArgs);
            int responseCode = this.client.executeMethod(method);
            String responseBody = method.getResponseBodyAsString();
            StatusLine statusLine = method.getStatusLine();
            this.debug(method);
            URL redirect = null;
            if (responseCode == 302) {
                redirect = this.extractRedirectURL(method);
            }
            if (!(handled = this.responseSelect.handle(new ResponseData(statusLine, responseBody, redirect, new URL(fetchURL))))) {
                this.logger.debug(responseBody);
                throw new UnexpectedAnswerException("unexpected response data (UiSimpleActionBase)").addFactoid("status", statusLine);
            }
        }
        catch (HttpException e) {
            throw new MethodException("method failed", e);
        }
        catch (IOException e) {
            throw new MethodException("method failed", e);
        }
        catch (InterruptedException e) {
            throw new MethodException("method aborted", e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }
}

