/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.mwapi.yurik;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.psammead.mwapi.MediaWikiException;
import net.psammead.mwapi.NameSpace;
import net.psammead.mwapi.ui.MethodException;
import net.psammead.mwapi.ui.UnexpectedAnswerException;
import net.psammead.mwapi.yurik.YurikErrorException;
import net.psammead.mwapi.yurik.YurikJSONException;
import net.psammead.mwapi.yurik.YurikQuery;
import net.psammead.mwapi.yurik.data.ErrorResult;
import net.psammead.mwapi.yurik.data.list.AllLinksResult;
import net.psammead.mwapi.yurik.data.list.AllLinks_alllinks;
import net.psammead.mwapi.yurik.data.list.AllLinks_l;
import net.psammead.mwapi.yurik.data.list.AllPagesResult;
import net.psammead.mwapi.yurik.data.list.AllPages_allpages;
import net.psammead.mwapi.yurik.data.list.AllPages_p;
import net.psammead.mwapi.yurik.data.list.AllUsersResult;
import net.psammead.mwapi.yurik.data.list.AllUsers_allusers;
import net.psammead.mwapi.yurik.data.list.AllUsers_u;
import net.psammead.mwapi.yurik.data.list.BackLinksResult;
import net.psammead.mwapi.yurik.data.list.BackLinks_backlinks;
import net.psammead.mwapi.yurik.data.list.BackLinks_bl;
import net.psammead.mwapi.yurik.data.list.CategoryMembersResult;
import net.psammead.mwapi.yurik.data.list.CategoryMembers_categorymembers;
import net.psammead.mwapi.yurik.data.list.CategoryMembers_cm;
import net.psammead.mwapi.yurik.data.list.EmbeddedInResult;
import net.psammead.mwapi.yurik.data.list.EmbeddedIn_ei;
import net.psammead.mwapi.yurik.data.list.EmbeddedIn_embeddedin;
import net.psammead.mwapi.yurik.data.list.ExtUrlUsageResult;
import net.psammead.mwapi.yurik.data.list.ExtUrlUsage_eu;
import net.psammead.mwapi.yurik.data.list.ExtUrlUsage_exturlusage;
import net.psammead.mwapi.yurik.data.list.ImageUsageResult;
import net.psammead.mwapi.yurik.data.list.ImageUsage_imageusage;
import net.psammead.mwapi.yurik.data.list.ImageUsage_iu;
import net.psammead.mwapi.yurik.data.list.LogEventsResult;
import net.psammead.mwapi.yurik.data.list.LogEvents_item;
import net.psammead.mwapi.yurik.data.list.LogEvents_logevents;
import net.psammead.mwapi.yurik.data.list.RecentChangesResult;
import net.psammead.mwapi.yurik.data.list.RecentChanges_rc;
import net.psammead.mwapi.yurik.data.list.RecentChanges_recentchanges;
import net.psammead.mwapi.yurik.data.list.UserContribsResult;
import net.psammead.mwapi.yurik.data.list.UserContribs_item;
import net.psammead.mwapi.yurik.data.list.UserContribs_usercontribs;
import net.psammead.mwapi.yurik.data.list.WatchListResult;
import net.psammead.mwapi.yurik.data.list.WatchList_item;
import net.psammead.mwapi.yurik.data.list.WatchList_watchlist;
import net.psammead.mwapi.yurik.data.prop.CategoriesResult;
import net.psammead.mwapi.yurik.data.prop.Categories_categories;
import net.psammead.mwapi.yurik.data.prop.Categories_cl;
import net.psammead.mwapi.yurik.data.prop.Categories_page;
import net.psammead.mwapi.yurik.data.prop.ExtLinksResult;
import net.psammead.mwapi.yurik.data.prop.ExtLinks_el;
import net.psammead.mwapi.yurik.data.prop.ExtLinks_extlinks;
import net.psammead.mwapi.yurik.data.prop.ExtLinks_page;
import net.psammead.mwapi.yurik.data.prop.ImageInfoResult;
import net.psammead.mwapi.yurik.data.prop.ImageInfo_ii;
import net.psammead.mwapi.yurik.data.prop.ImageInfo_imageinfo;
import net.psammead.mwapi.yurik.data.prop.ImageInfo_page;
import net.psammead.mwapi.yurik.data.prop.ImagesResult;
import net.psammead.mwapi.yurik.data.prop.Images_im;
import net.psammead.mwapi.yurik.data.prop.Images_images;
import net.psammead.mwapi.yurik.data.prop.Images_page;
import net.psammead.mwapi.yurik.data.prop.InfoResult;
import net.psammead.mwapi.yurik.data.prop.Info_page;
import net.psammead.mwapi.yurik.data.prop.LangLinksResult;
import net.psammead.mwapi.yurik.data.prop.LangLinks_langlinks;
import net.psammead.mwapi.yurik.data.prop.LangLinks_li;
import net.psammead.mwapi.yurik.data.prop.LangLinks_page;
import net.psammead.mwapi.yurik.data.prop.LinksResult;
import net.psammead.mwapi.yurik.data.prop.Links_links;
import net.psammead.mwapi.yurik.data.prop.Links_page;
import net.psammead.mwapi.yurik.data.prop.Links_pl;
import net.psammead.mwapi.yurik.data.prop.RevisionsResult;
import net.psammead.mwapi.yurik.data.prop.Revisions_page;
import net.psammead.mwapi.yurik.data.prop.Revisions_rev;
import net.psammead.mwapi.yurik.data.prop.Revisions_revisions;
import net.psammead.mwapi.yurik.data.prop.TemplatesResult;
import net.psammead.mwapi.yurik.data.prop.Templates_page;
import net.psammead.mwapi.yurik.data.prop.Templates_templates;
import net.psammead.mwapi.yurik.data.prop.Templates_tl;
import net.psammead.mwapi.yurik.json.Copy;
import net.psammead.mwapi.yurik.json.CreateObj;
import net.psammead.mwapi.yurik.json.ExistsToBool;
import net.psammead.mwapi.yurik.json.IsoToDate;
import net.psammead.mwapi.yurik.json.JSONConverter;
import net.psammead.mwapi.yurik.json.JSONConverterContext;
import net.psammead.mwapi.yurik.json.JSONConverterException;
import net.psammead.mwapi.yurik.json.ListIter;
import net.psammead.mwapi.yurik.json.LongToInt;
import net.psammead.mwapi.yurik.json.MapEntry;
import net.psammead.mwapi.yurik.json.MapValuesIter;
import net.psammead.mwapi.yurik.json.NullSafe;
import net.psammead.mwapi.yurik.json.TitleToLocation;
import net.psammead.util.Logger;
import net.psammead.util.Throttle;
import net.psammead.util.json.JSONDecodeException;
import net.psammead.util.json.JSONDecoder;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YurikAPI {
    private final Logger logger;
    private final HttpClient client;
    private final Throttle throttle;
    private final String apiURL;
    private final String charSet;
    private final String userAgent;
    private final JSONConverterContext ctx;
    public static final JSONConverter CATEGORIES_CONVERTER = new CreateObj(CategoriesResult.class, new MapEntry("query", new MapEntry("pages", new MapValuesIter(new CreateObj(Categories_page.class, new MapEntry("title", new TitleToLocation()), new MapEntry("pageid", new Copy()), new MapEntry("categories", new CreateObj(Categories_categories.class, new ListIter(new CreateObj(Categories_cl.class, new MapEntry("title", new TitleToLocation()), new MapEntry("sortkey", new Copy()))))))))));
    public static final JSONConverter EXTLINKS_CONVERTER = new CreateObj(ExtLinksResult.class, new MapEntry("query", new MapEntry("pages", new MapValuesIter(new CreateObj(ExtLinks_page.class, new MapEntry("title", new TitleToLocation()), new MapEntry("pageid", new Copy()), new MapEntry("extlinks", new CreateObj(ExtLinks_extlinks.class, new ListIter(new CreateObj(ExtLinks_el.class, new MapEntry("*", new Copy()))))))))));
    public static final JSONConverter IMAGEINFO_CONVERTER = new CreateObj(ImageInfoResult.class, new MapEntry("query", new MapEntry("pages", new MapValuesIter(new CreateObj(ImageInfo_page.class, new MapEntry("title", new TitleToLocation()), new MapEntry("pageid", new Copy()), new MapEntry("imagerepository", new Copy()), new MapEntry("imageinfo", new CreateObj(ImageInfo_imageinfo.class, new ListIter(new CreateObj(ImageInfo_ii.class, new MapEntry("timestamp", new IsoToDate()), new MapEntry("user", new Copy()), new MapEntry("size", new Copy()), new MapEntry("width", new LongToInt()), new MapEntry("height", new LongToInt()), new MapEntry("url", new Copy()), new MapEntry("comment", new Copy()), new MapEntry("content", new Copy()))))))))));
    public static final JSONConverter IMAGES_CONVERTER = new CreateObj(ImagesResult.class, new MapEntry("query", new MapEntry("pages", new MapValuesIter(new CreateObj(Images_page.class, new MapEntry("title", new TitleToLocation()), new MapEntry("pageid", new Copy()), new MapEntry("images", new CreateObj(Images_images.class, new NullSafe(new ListIter(new CreateObj(Images_im.class, new MapEntry("title", new TitleToLocation())))))))))));
    public static final JSONConverter INFO_CONVERTER = new CreateObj(InfoResult.class, new MapEntry("query", new MapEntry("pages", new MapValuesIter(new CreateObj(Info_page.class, new MapEntry("title", new TitleToLocation()), new MapEntry("pageid", new Copy()), new MapEntry("lastrevid", new Copy()), new MapEntry("touched", new IsoToDate()), new MapEntry("counter", new LongToInt()), new MapEntry("length", new LongToInt()), new MapEntry("redirect", new ExistsToBool()))))));
    public static final JSONConverter LANGLINKS_CONVERTER = new CreateObj(LangLinksResult.class, new MapEntry("query", new MapEntry("pages", new MapValuesIter(new CreateObj(LangLinks_page.class, new MapEntry("title", new TitleToLocation()), new MapEntry("pageid", new Copy()), new MapEntry("langlinks", new CreateObj(LangLinks_langlinks.class, new ListIter(new CreateObj(LangLinks_li.class, new MapEntry("lang", new Copy()))))))))));
    public static final JSONConverter LINKS_CONVERTER = new CreateObj(LinksResult.class, new MapEntry("query", new MapEntry("pages", new MapValuesIter(new CreateObj(Links_page.class, new MapEntry("title", new TitleToLocation()), new MapEntry("pageid", new Copy()), new MapEntry("links", new CreateObj(Links_links.class, new ListIter(new CreateObj(Links_pl.class, new MapEntry("title", new TitleToLocation()))))))))));
    public static final int REVISIONS_MAX_LIMIT = 50;
    public static final JSONConverter REVISIONS_CONVERTER = new CreateObj(RevisionsResult.class, new MapEntry("query", new MapEntry("pages", new MapValuesIter(new CreateObj(Revisions_page.class, new MapEntry("title", new TitleToLocation()), new MapEntry("pageid", new Copy()), new MapEntry("revisions", new CreateObj(Revisions_revisions.class, new ListIter(new CreateObj(Revisions_rev.class, new MapEntry("revid", new Copy()), new MapEntry("user", new Copy()), new MapEntry("timestamp", new IsoToDate()), new MapEntry("comment", new Copy()), new MapEntry("minor", new ExistsToBool()), new MapEntry("anon", new ExistsToBool()), new MapEntry("content", new Copy()))))))))));
    public static final JSONConverter TEMPLATES_CONVERTER = new CreateObj(TemplatesResult.class, new MapEntry("query", new MapEntry("pages", new MapValuesIter(new CreateObj(Templates_page.class, new MapEntry("title", new TitleToLocation()), new MapEntry("pageid", new Copy()), new MapEntry("templates", new CreateObj(Templates_templates.class, new ListIter(new CreateObj(Templates_tl.class, new MapEntry("title", new TitleToLocation()))))))))));
    public static final int ALLPAGES_MAX_LIMIT = 500;
    public static final JSONConverter ALLPAGES_CONVERTER = new CreateObj(AllPagesResult.class, new MapEntry("query", new CreateObj(AllPages_allpages.class, new MapEntry("allpages", new ListIter(new CreateObj(AllPages_p.class, new MapEntry("title", new TitleToLocation()), new MapEntry("pageid", new Copy())))))), new MapEntry("query-continue", new NullSafe(new MapEntry("allpages", new MapEntry("apfrom", new Copy())))));
    public static final int ALLLINKS_MAX_LIMIT = 500;
    public static final JSONConverter ALLLINKS_CONVERTER = new CreateObj(AllLinksResult.class, new MapEntry("query", new CreateObj(AllLinks_alllinks.class, new MapEntry("alllinks", new ListIter(new CreateObj(AllLinks_l.class, new MapEntry("title", new TitleToLocation()), new MapEntry("fromid", new Copy())))))), new MapEntry("query-continue", new NullSafe(new MapEntry("alllinks", new MapEntry("alfrom", new Copy())))));
    public static final int ALLUSERS_MAX_LIMIT = 500;
    public static final JSONConverter ALLUSERS_CONVERTER = new CreateObj(AllUsersResult.class, new MapEntry("query", new CreateObj(AllUsers_allusers.class, new MapEntry("allusers", new ListIter(new CreateObj(AllUsers_u.class, new MapEntry("name", new Copy()), new MapEntry("editcount", new LongToInt())))))), new MapEntry("query-continue", new NullSafe(new MapEntry("allusers", new MapEntry("aufrom", new Copy())))));
    public static final int BACKLINKS_MAX_LIMIT = 500;
    public static final JSONConverter BACKLINKS_CONVERTER = new CreateObj(BackLinksResult.class, new MapEntry("query", new CreateObj(BackLinks_backlinks.class, new MapEntry("backlinks", new ListIter(new CreateObj(BackLinks_bl.class, new MapEntry("title", new TitleToLocation()), new MapEntry("pageid", new Copy())))))), new MapEntry("query-continue", new NullSafe(new MapEntry("backlinks", new MapEntry("blcontinue", new Copy())))));
    public static final int CATEGORYMEMBERS_MAX_LIMIT = 500;
    public static final JSONConverter CATEGORYMEMBERS_CONVERTER = new CreateObj(CategoryMembersResult.class, new MapEntry("query", new CreateObj(CategoryMembers_categorymembers.class, new MapEntry("categorymembers", new ListIter(new CreateObj(CategoryMembers_cm.class, new MapEntry("title", new TitleToLocation()), new MapEntry("pageid", new Copy()), new MapEntry("sortkey", new Copy())))))), new MapEntry("query-continue", new NullSafe(new MapEntry("categorymembers", new MapEntry("cmcontinue", new Copy())))));
    public static final int EMBEDDEDIN_MAX_LIMIT = 500;
    public static final JSONConverter EMBEDDEDIN_CONVERTER = new CreateObj(EmbeddedInResult.class, new MapEntry("query", new CreateObj(EmbeddedIn_embeddedin.class, new MapEntry("embeddedin", new ListIter(new CreateObj(EmbeddedIn_ei.class, new MapEntry("title", new TitleToLocation()), new MapEntry("pageid", new Copy())))))), new MapEntry("query-continue", new NullSafe(new MapEntry("embeddedin", new MapEntry("eicontinue", new Copy())))));
    public static final int EXTURLUSAGE_MAX_LIMIT = 500;
    public static final JSONConverter EXTURLUSAGE_CONVERTER = new CreateObj(ExtUrlUsageResult.class, new MapEntry("query", new CreateObj(ExtUrlUsage_exturlusage.class, new MapEntry("exturlusage", new ListIter(new CreateObj(ExtUrlUsage_eu.class, new MapEntry("title", new TitleToLocation()), new MapEntry("pageid", new Copy()), new MapEntry("url", new Copy())))))), new MapEntry("query-continue", new NullSafe(new MapEntry("exturlusage", new MapEntry("euoffset", new LongToInt())))));
    public static final int IMAGEUSAGE_MAX_LIMIT = 500;
    public static final JSONConverter IMAGEUSAGE_CONVERTER = new CreateObj(ImageUsageResult.class, new MapEntry("query", new CreateObj(ImageUsage_imageusage.class, new MapEntry("imageusage", new ListIter(new CreateObj(ImageUsage_iu.class, new MapEntry("title", new TitleToLocation()), new MapEntry("pageid", new Copy())))))), new MapEntry("query-continue", new NullSafe(new MapEntry("imageusage", new MapEntry("iucontinue", new Copy())))));
    public static final int LOGEVENTS_MAX_LIMIT = 500;
    public static final JSONConverter LOGEVENTS_CONVERTER = new CreateObj(LogEventsResult.class, new MapEntry("query", new CreateObj(LogEvents_logevents.class, new MapEntry("logevents", new ListIter(new CreateObj(LogEvents_item.class, new MapEntry("title", new TitleToLocation()), new MapEntry("pageid", new Copy()), new MapEntry("logid", new LongToInt()), new MapEntry("timestamp", new IsoToDate()), new MapEntry("type", new Copy()), new MapEntry("action", new Copy()), new MapEntry("user", new Copy()), new MapEntry("comment", new Copy())))))), new MapEntry("query-continue", new NullSafe(new MapEntry("logevents", new MapEntry("lestart", new IsoToDate())))));
    public static final int RECENTCHANGES_MAX_LIMIT = 500;
    public static final JSONConverter RECENTCHANGES_CONVERTER = new CreateObj(RecentChangesResult.class, new MapEntry("query", new CreateObj(RecentChanges_recentchanges.class, new MapEntry("recentchanges", new ListIter(new CreateObj(RecentChanges_rc.class, new MapEntry("title", new TitleToLocation()), new MapEntry("pageid", new Copy()), new MapEntry("revid", new Copy()), new MapEntry("old_revid", new Copy()), new MapEntry("rcid", new Copy()), new MapEntry("timestamp", new IsoToDate()), new MapEntry("new", new ExistsToBool()), new MapEntry("minor", new ExistsToBool()), new MapEntry("anon", new ExistsToBool()), new MapEntry("type", new Copy()), new MapEntry("user", new Copy()), new MapEntry("oldlen", new LongToInt()), new MapEntry("newlen", new LongToInt()), new MapEntry("comment", new Copy())))))), new MapEntry("query-continue", new NullSafe(new MapEntry("recentchanges", new MapEntry("rcstart", new IsoToDate())))));
    public static final int USERCONTRIBS_MAX_LIMIT = 500;
    public static final JSONConverter USERCONTRIBS_CONVERTER = new CreateObj(UserContribsResult.class, new MapEntry("query", new CreateObj(UserContribs_usercontribs.class, new MapEntry("usercontribs", new ListIter(new CreateObj(UserContribs_item.class, new MapEntry("title", new TitleToLocation()), new MapEntry("pageid", new Copy()), new MapEntry("revid", new Copy()), new MapEntry("timestamp", new IsoToDate()), new MapEntry("new", new ExistsToBool()), new MapEntry("minor", new ExistsToBool()), new MapEntry("comment", new Copy())))))), new MapEntry("query-continue", new NullSafe(new MapEntry("usercontribs", new MapEntry("ucstart", new IsoToDate())))));
    public static final int WATCHLIST_MAX_LIMIT = 500;
    public static final JSONConverter WATCHLIST_CONVERTER = new CreateObj(WatchListResult.class, new MapEntry("query", new CreateObj(WatchList_watchlist.class, new MapEntry("watchlist", new ListIter(new CreateObj(WatchList_item.class, new MapEntry("title", new TitleToLocation()), new MapEntry("pageid", new Copy()), new MapEntry("revid", new Copy()), new MapEntry("timestamp", new IsoToDate()), new MapEntry("new", new ExistsToBool()), new MapEntry("minor", new ExistsToBool()), new MapEntry("anon", new ExistsToBool()), new MapEntry("type", new Copy()), new MapEntry("user", new Copy()), new MapEntry("oldlen", new LongToInt()), new MapEntry("newlen", new LongToInt()), new MapEntry("comment", new Copy())))))), new MapEntry("query-continue", new NullSafe(new MapEntry("watchlist", new MapEntry("wlstart", new IsoToDate())))));
    public static final JSONConverter ERROR_CONVERTER = new MapEntry("error", new CreateObj(ErrorResult.class, new MapEntry("code", new Copy()), new MapEntry("info", new Copy()), new MapEntry("*", new Copy())));

    public YurikAPI(Logger logger, HttpClient client, Throttle throttle, String apiURL, String userAgent, String wiki, String charSet) {
        this.logger = logger;
        this.client = client;
        this.throttle = throttle;
        this.apiURL = apiURL;
        this.userAgent = userAgent;
        this.charSet = charSet;
        this.ctx = new JSONConverterContext(wiki);
    }

    public CategoriesResult categories(String title) throws MediaWikiException {
        YurikQuery query = new YurikQuery();
        query.string("action", "query");
        query.string("format", "json");
        query.string("prop", "categories");
        query.string("titles", title);
        query.string("clprop", "sortkey");
        return (CategoriesResult)this.apiJSON(query, CATEGORIES_CONVERTER);
    }

    public ExtLinksResult extLinks(String title) throws MediaWikiException {
        YurikQuery query = new YurikQuery();
        query.string("action", "query");
        query.string("format", "json");
        query.string("prop", "extlinks");
        query.string("titles", title);
        return (ExtLinksResult)this.apiJSON(query, EXTLINKS_CONVERTER);
    }

    public ImageInfoResult imageInfo(String title) throws MediaWikiException {
        YurikQuery query = new YurikQuery();
        query.string("action", "query");
        query.string("format", "json");
        query.string("prop", "imageinfo");
        query.string("titles", title);
        query.string("iiprop", "timestamp|user|comment|url|size");
        query.bool("iihistory", true);
        return (ImageInfoResult)this.apiJSON(query, IMAGEINFO_CONVERTER);
    }

    public ImagesResult images(String title) throws MediaWikiException {
        YurikQuery query = new YurikQuery();
        query.string("action", "query");
        query.string("format", "json");
        query.string("prop", "images");
        query.string("titles", title);
        return (ImagesResult)this.apiJSON(query, IMAGES_CONVERTER);
    }

    public InfoResult info(String title) throws MediaWikiException {
        YurikQuery query = new YurikQuery();
        query.string("action", "query");
        query.string("format", "json");
        query.string("prop", "info");
        query.string("titles", title);
        query.string("inprop", "protection");
        return (InfoResult)this.apiJSON(query, INFO_CONVERTER);
    }

    public LangLinksResult langLinks(String title) throws MediaWikiException {
        YurikQuery query = new YurikQuery();
        query.string("action", "query");
        query.string("format", "json");
        query.string("prop", "langlinks");
        query.string("titles", title);
        return (LangLinksResult)this.apiJSON(query, LANGLINKS_CONVERTER);
    }

    public LinksResult links(String title, List<NameSpace> nameSpaces) throws MediaWikiException {
        YurikQuery query = new YurikQuery();
        query.string("action", "query");
        query.string("format", "json");
        query.string("prop", "links");
        query.string("titles", title);
        query.nameSpaces("plnamespace", nameSpaces);
        return (LinksResult)this.apiJSON(query, LINKS_CONVERTER);
    }

    public RevisionsResult revisions(String title, Long startId, Long endId, Date start, Date end, boolean newer, String user, String excludeUser, int limit) throws MediaWikiException {
        YurikQuery query = new YurikQuery();
        query.string("action", "query");
        query.string("format", "json");
        query.string("prop", "revisions");
        query.string("titles", title);
        query.string("rvprop", "ids|flags|timestamp|user|comment");
        query.number("rvstartid", startId);
        query.number("rvendid", endId);
        query.date("rvstart", start);
        query.date("rvend", end);
        query.direction("rvdir", newer);
        query.string("rvuser", user);
        query.string("rvexcludeuser", excludeUser);
        query.limit("rvlimit", limit, 50);
        return (RevisionsResult)this.apiJSON(query, REVISIONS_CONVERTER);
    }

    public TemplatesResult templates(String title, List<NameSpace> nameSpaces) throws MediaWikiException {
        YurikQuery query = new YurikQuery();
        query.string("action", "query");
        query.string("format", "json");
        query.string("prop", "templates");
        query.string("titles", title);
        query.nameSpaces("tlnamespace", nameSpaces);
        return (TemplatesResult)this.apiJSON(query, TEMPLATES_CONVERTER);
    }

    public AllPagesResult allPages(String from, String prefix, List<NameSpace> nameSpaces, String filterRedir, int limit) throws MediaWikiException {
        YurikQuery query = new YurikQuery();
        query.string("action", "query");
        query.string("format", "json");
        query.string("list", "allpages");
        query.string("apfrom", from);
        query.string("apprefix", prefix);
        query.nameSpaces("apnamespace", nameSpaces);
        query.filterRedir("apfilterredir", filterRedir);
        query.limit("aplimit", limit, 500);
        return (AllPagesResult)this.apiJSON(query, ALLPAGES_CONVERTER);
    }

    public AllLinksResult allLinks(String from, String prefix, List<NameSpace> nameSpaces, int limit) throws MediaWikiException {
        YurikQuery query = new YurikQuery();
        query.string("action", "query");
        query.string("format", "json");
        query.string("list", "alllinks");
        query.string("alprop", "ids|title");
        query.string("alfrom", from);
        query.string("alprefix", prefix);
        query.nameSpaces("alnamespace", nameSpaces);
        query.bool("alunique", false);
        query.limit("allimit", limit, 500);
        return (AllLinksResult)this.apiJSON(query, ALLLINKS_CONVERTER);
    }

    public AllUsersResult allUsers(String from, String prefix, List<NameSpace> nameSpaces, String group, int limit) throws MediaWikiException {
        YurikQuery query = new YurikQuery();
        query.string("action", "query");
        query.string("format", "json");
        query.string("list", "allusers");
        query.string("auprop", "editcount|groups");
        query.string("aufrom", from);
        query.string("auprefix", prefix);
        query.nameSpaces("alnamespace", nameSpaces);
        query.group("augroup", group);
        query.limit("aulimit", limit, 500);
        return (AllUsersResult)this.apiJSON(query, ALLUSERS_CONVERTER);
    }

    public BackLinksResult backLinks(String title, List<NameSpace> nameSpaces, boolean redirect, int limit, String continueKey) throws MediaWikiException {
        YurikQuery query = new YurikQuery();
        query.string("action", "query");
        query.string("format", "json");
        query.string("list", "backlinks");
        query.string("bltitle", title);
        query.nameSpaces("blnamespace", nameSpaces);
        query.bool("blredirect", redirect);
        query.string("blcontinue", continueKey);
        query.limit("bllimit", limit, 500);
        return (BackLinksResult)this.apiJSON(query, BACKLINKS_CONVERTER);
    }

    public CategoryMembersResult categoryMembers(String category, List<NameSpace> nameSpaces, int limit, String continueKey) throws MediaWikiException {
        YurikQuery query = new YurikQuery();
        query.string("action", "query");
        query.string("format", "json");
        query.string("list", "categorymembers");
        query.string("cmcategory", category);
        query.string("cmprop", "ids|title|sortkey");
        query.nameSpaces("cmnamespace", nameSpaces);
        query.string("cmcontinue", continueKey);
        query.limit("cmlimit", limit, 500);
        return (CategoryMembersResult)this.apiJSON(query, CATEGORYMEMBERS_CONVERTER);
    }

    public EmbeddedInResult embeddedIn(String title, List<NameSpace> nameSpaces, boolean redirect, int limit, String continueKey) throws MediaWikiException {
        YurikQuery query = new YurikQuery();
        query.string("action", "query");
        query.string("format", "json");
        query.string("list", "embeddedin");
        query.string("eititle", title);
        query.nameSpaces("einamespace", nameSpaces);
        query.bool("eiredirect", redirect);
        query.string("eicontinue", continueKey);
        query.limit("eilimit", limit, 500);
        return (EmbeddedInResult)this.apiJSON(query, EMBEDDEDIN_CONVERTER);
    }

    public ExtUrlUsageResult extUrlUsage(String protocol, String search, List<NameSpace> nameSpaces, int limit, String continueKey) throws MediaWikiException {
        YurikQuery query = new YurikQuery();
        query.string("action", "query");
        query.string("format", "json");
        query.string("list", "exturlusage");
        query.string("euquery", search);
        query.protocol("euprotocol", protocol);
        query.string("euprop", "ids|title|url");
        query.nameSpaces("eunamespace", nameSpaces);
        query.string("euoffset", continueKey);
        query.limit("eulimit", limit, 500);
        return (ExtUrlUsageResult)this.apiJSON(query, EXTURLUSAGE_CONVERTER);
    }

    public ImageUsageResult imageUsage(String title, List<NameSpace> nameSpaces, boolean redirect, int limit, String continueKey) throws MediaWikiException {
        YurikQuery query = new YurikQuery();
        query.string("action", "query");
        query.string("format", "json");
        query.string("list", "imageusage");
        query.string("iutitle", title);
        query.nameSpaces("iunamespace", nameSpaces);
        query.bool("iuredirect", redirect);
        query.string("iucontinue", continueKey);
        query.limit("iulimit", limit, 500);
        return (ImageUsageResult)this.apiJSON(query, IMAGEUSAGE_CONVERTER);
    }

    public LogEventsResult logEvents(Date start, Date end, boolean newer, String user, String title, int limit) throws MediaWikiException {
        YurikQuery query = new YurikQuery();
        query.string("action", "query");
        query.string("format", "json");
        query.string("list", "logevents");
        query.string("leprop", "ids|title|type|user|timestamp|comment|details");
        query.string("letype", "block|protect|rights|delete|upload|move|import|patrol|renameuser|newusers|makebot");
        query.date("lestart", start);
        query.date("leend", end);
        query.direction("ledir", newer);
        query.string("leuser", user);
        query.string("letitle", title);
        query.limit("lelimit", limit, 500);
        return (LogEventsResult)this.apiJSON(query, LOGEVENTS_CONVERTER);
    }

    public RecentChangesResult recentChanges(List<NameSpace> nameSpaces, Date start, Date end, boolean newer, int limit) throws MediaWikiException {
        YurikQuery query = new YurikQuery();
        query.string("action", "query");
        query.string("format", "json");
        query.string("list", "recentchanges");
        query.string("rcprop", "user|comment|flags|timestamp|title|ids|sizes");
        query.nameSpaces("rcnamespace", nameSpaces);
        query.date("rcstart", start);
        query.date("rcend", end);
        query.direction("rcdir", newer);
        query.limit("rclimit", limit, 500);
        return (RecentChangesResult)this.apiJSON(query, RECENTCHANGES_CONVERTER);
    }

    public UserContribsResult userContribs(String user, List<NameSpace> nameSpaces, Date start, Date end, boolean newer, int limit) throws MediaWikiException {
        YurikQuery query = new YurikQuery();
        query.string("action", "query");
        query.string("format", "json");
        query.string("list", "usercontribs");
        query.string("ucuser", user);
        query.string("ucprop", "ids|title|timestamp|comment|flags");
        query.nameSpaces("ucnamespace", nameSpaces);
        query.date("ucstart", start);
        query.date("ucend", end);
        query.direction("ucdir", newer);
        query.limit("uclimit", limit, 500);
        return (UserContribsResult)this.apiJSON(query, USERCONTRIBS_CONVERTER);
    }

    public WatchListResult watchList(List<NameSpace> nameSpaces, Date start, Date end, boolean newer, int limit) throws MediaWikiException {
        YurikQuery query = new YurikQuery();
        query.string("action", "query");
        query.string("format", "json");
        query.string("list", "watchlist");
        query.string("wlprop", "ids|title|flags|user|comment|timestamp|sizes");
        query.bool("wlallrev", true);
        query.nameSpaces("wlnamespace", nameSpaces);
        query.date("wlstart", start);
        query.date("wlend", end);
        query.direction("wldir", newer);
        query.limit("wllimit", limit, 500);
        return (WatchListResult)this.apiJSON(query, WATCHLIST_CONVERTER);
    }

    private Object apiJSON(YurikQuery query, JSONConverter resultConverter) throws MediaWikiException {
        Object json;
        String raw = this.apiGET(query.toQueryString(this.charSet));
        try {
            json = JSONDecoder.decode((String)raw);
        }
        catch (JSONDecodeException e) {
            throw new YurikJSONException("json decoding failed", e).addFactoid("content", raw);
        }
        if (!(json instanceof Map)) {
            throw new YurikJSONException("expected a Map at top level").addFactoid("content", raw).addFactoid("json", json);
        }
        Map data = (Map)json;
        try {
            if (data.get("error") != null) {
                throw new YurikErrorException((ErrorResult)ERROR_CONVERTER.convert(this.ctx, json));
            }
            return resultConverter.convert(this.ctx, json);
        }
        catch (JSONConverterException e) {
            throw new YurikJSONException("json conversion failed", e).addFactoid("content", raw).addFactoid("json", json);
        }
    }

    private String apiGET(String query) throws MediaWikiException {
        GetMethod method = null;
        try {
            this.throttle.gate();
            method = new GetMethod(this.apiURL);
            method.getParams().setCookiePolicy("rfc2109");
            method.setFollowRedirects(false);
            method.addRequestHeader("User-Agent", this.userAgent);
            method.setQueryString(query);
            int responseCode = this.client.executeMethod((HttpMethod)method);
            String responseBody = method.getResponseBodyAsString();
            StatusLine statusLine = method.getStatusLine();
            this.debug((HttpMethod)method);
            if (responseCode != 200) {
                throw new UnexpectedAnswerException("unexpected response code (YurikAPI)").addFactoid("status", statusLine).addFactoid("content", responseBody);
            }
            String string = responseBody;
            return string;
        }
        catch (HttpException e) {
            throw new MethodException("method failed", e);
        }
        catch (IOException e) {
            throw new MethodException("method failed", e);
        }
        catch (InterruptedException e) {
            throw new MethodException("method aborted", e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    protected void debug(HttpMethod method) throws URIException {
        this.logger.debug("HTTP " + method.getName() + " " + method.getURI().toString() + " " + method.getStatusLine());
    }
}

