/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util;

import net.psammead.util.Function;
import net.psammead.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Functions {
    private Functions() {
    }

    public static <T> Function<T, T> identity() {
        return new Function<T, T>(){

            @Override
            public T apply(T source) {
                return source;
            }
        };
    }

    public static <S, T> Function<S, T> constant(final T value) {
        return new Function<S, T>(){

            @Override
            public T apply(S source) {
                return value;
            }
        };
    }

    public static <R, S, T> Function<R, T> compose(final Function<R, S> first, final Function<S, T> second) {
        return new Function<R, T>(){

            @Override
            public T apply(R source) {
                return second.apply(first.apply(source));
            }
        };
    }

    public static <S> Function<S, String> safeToString() {
        return new Function<S, String>(){

            @Override
            public String apply(S source) {
                return StringUtil.safeToString(source);
            }
        };
    }
}

