/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.psammead.util.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListUtil {
    private ListUtil() {
    }

    public static <T> List<T> create(T ... in) {
        ArrayList<T> out = new ArrayList<T>();
        for (T element : in) {
            out.add(element);
        }
        return out;
    }

    public static <T> List<T> create(Iterable<T> in) {
        ArrayList<T> out = new ArrayList<T>();
        for (T element : in) {
            out.add(element);
        }
        return out;
    }

    public static <T, X extends T> List<T> single(X element) {
        ArrayList<X> out = new ArrayList<X>();
        out.add(element);
        return out;
    }

    public static <T> List<T> filter(List<T> in, Function<? super T, Boolean> filter) {
        ArrayList<T> out = new ArrayList<T>();
        for (T element : in) {
            if (!filter.apply(element).booleanValue()) continue;
            out.add(element);
        }
        return out;
    }

    public static <S, T> List<T> map(List<S> in, Function<? super S, ? extends T> transformer) {
        ArrayList<T> out = new ArrayList<T>();
        for (S element : in) {
            out.add(transformer.apply(element));
        }
        return out;
    }

    public static <T> List<T> concat(List<T> a, List<T> b) {
        ArrayList<T> out = new ArrayList<T>();
        out.addAll(a);
        out.addAll(b);
        return out;
    }

    public static <T> List<T> intersection(List<T> a, List<T> b) {
        ArrayList<T> out = new ArrayList<T>();
        out.addAll(a);
        out.retainAll(b);
        return out;
    }

    public static <T> List<T> without(List<T> a, List<T> b) {
        ArrayList<T> out = new ArrayList<T>();
        out.addAll(a);
        out.removeAll(b);
        return out;
    }

    public static <T> List<T> difference(List<T> a, List<T> b) {
        return ListUtil.without(ListUtil.concat(a, b), ListUtil.intersection(a, b));
    }

    public static <T> List<T> reverse(List<T> in) {
        ArrayList<T> out = new ArrayList<T>(in);
        Collections.reverse(out);
        return out;
    }

    public static <T extends Comparable<? super T>> List<T> sort(List<T> in) {
        ArrayList<T> out = new ArrayList<T>(in);
        Collections.sort(out);
        return out;
    }

    public static <T> List<T> sort(List<T> in, Comparator<? super T> comparator) {
        ArrayList<T> out = new ArrayList<T>(in);
        Collections.sort(out, comparator);
        return out;
    }

    public static <T> T first(List<T> list) {
        return list.get(0);
    }

    public static <T> T last(List<T> list) {
        return list.get(ListUtil.lastIndex(list));
    }

    public static int lastIndex(List<?> list) {
        return list.size() - 1;
    }

    public static boolean containsIndex(List<?> list, int index) {
        return index >= 0 && index < list.size();
    }

    public static <T> T getOrElse(List<T> list, int index, T elseValue) {
        if (ListUtil.containsIndex(list, index)) {
            return list.get(index);
        }
        return elseValue;
    }
}

