/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util;

import java.util.HashSet;
import java.util.Set;
import net.psammead.util.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SetUtil {
    private SetUtil() {
    }

    public static <T> Set<T> create(T ... in) {
        HashSet<T> out = new HashSet<T>();
        for (T element : in) {
            out.add(element);
        }
        return out;
    }

    public static <T> Set<T> create(Iterable<T> in) {
        HashSet<T> out = new HashSet<T>();
        for (T element : in) {
            out.add(element);
        }
        return out;
    }

    public static <T, X extends T> Set<T> single(X element) {
        HashSet<X> out = new HashSet<X>();
        out.add(element);
        return out;
    }

    public static <T> Set<T> filter(Set<T> in, Function<? super T, Boolean> filter) {
        HashSet<T> out = new HashSet<T>();
        for (T element : in) {
            if (!filter.apply(element).booleanValue()) continue;
            out.add(element);
        }
        return out;
    }

    public static <S, T> Set<T> map(Set<S> in, Function<? super S, ? extends T> transformer) {
        HashSet<T> out = new HashSet<T>();
        for (S element : in) {
            out.add(transformer.apply(element));
        }
        return out;
    }

    public static <T> Set<T> union(Set<T> a, Set<T> b) {
        HashSet<T> out = new HashSet<T>();
        out.addAll(a);
        out.addAll(b);
        return out;
    }

    public static <T> Set<T> intersection(Set<T> a, Set<T> b) {
        HashSet<T> out = new HashSet<T>();
        out.addAll(a);
        out.retainAll(b);
        return out;
    }

    public static <T> Set<T> without(Set<T> a, Set<T> b) {
        HashSet<T> out = new HashSet<T>();
        out.addAll(a);
        out.removeAll(b);
        return out;
    }

    public static <T> Set<T> difference(Set<T> a, Set<T> b) {
        return SetUtil.without(SetUtil.union(a, b), SetUtil.intersection(a, b));
    }
}

