/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util;

import java.util.StringTokenizer;
import net.psammead.util.Scan;

public final class TextUtil {
    public static final String MAC_LF = "\r";
    public static final String UNIX_LF = "\n";
    public static final String DOS_LF = "\r\n";

    private TextUtil() {
    }

    public static String indent(String s) {
        return s.replaceAll("(?m)^", "\t");
    }

    public static String macLF(String text) {
        return TextUtil.convertLF(text, MAC_LF);
    }

    public static String unixLF(String text) {
        return TextUtil.convertLF(text, UNIX_LF);
    }

    public static String dosLF(String text) {
        return TextUtil.convertLF(text, DOS_LF);
    }

    public static String convertLF(String text, String lf) {
        StringBuilder b = new StringBuilder();
        Scan t = new Scan(text);
        while (!t.isFinished()) {
            b.append(t.line());
            if (!t.eol()) continue;
            b.append(lf);
        }
        return b.toString();
    }

    public static String trim(String text) {
        char c;
        int end;
        char c2;
        int start;
        int length = text.length();
        for (start = 0; start < length && Character.isSpaceChar(c2 = text.charAt(start)); ++start) {
        }
        for (end = length - 1; end > start && Character.isSpaceChar(c = text.charAt(end)); --end) {
        }
        return text.substring(start, end + 1);
    }

    public static String expandTabs(String s, int width) {
        String line;
        int next;
        StringBuilder out = new StringBuilder();
        int pos = 0;
        while ((next = s.indexOf(UNIX_LF, pos)) != -1) {
            line = s.substring(pos, next);
            pos = next + 1;
            TextUtil.expandTabLine(line, width, out);
            out.append(UNIX_LF);
        }
        next = s.length();
        line = s.substring(pos, next);
        TextUtil.expandTabLine(line, width, out);
        return out.toString();
    }

    public static String expandTabLine(String s, int width) {
        StringBuilder out = new StringBuilder();
        TextUtil.expandTabLine(s, width, out);
        return out.toString();
    }

    public static void expandTabLine(String s, int width, StringBuilder out) {
        int next;
        int column = 0;
        int pos = 0;
        while ((next = s.indexOf("\t", pos)) != -1) {
            out.append(s.substring(pos, next));
            int spaces = width - (column += next - pos) % width;
            for (int i = 0; i < spaces; ++i) {
                out.append(' ');
            }
            column += spaces;
            pos = next + 1;
        }
        next = s.length();
        out.append(s.substring(pos, next));
    }

    public static String wordWrap(String text, int width) {
        String normalized = text.replaceAll(DOS_LF, UNIX_LF).replaceAll(MAC_LF, UNIX_LF);
        StringTokenizer tokenizer = new StringTokenizer(normalized, " \n", true);
        StringBuilder out = new StringBuilder();
        int pos = 0;
        String space = "";
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (UNIX_LF.equals(token)) {
                out.append('\n');
                pos = 0;
                space = "";
                continue;
            }
            if (" ".equals(token)) {
                space = space + token;
                continue;
            }
            int maybe = pos + space.length() + token.length();
            if (maybe <= width) {
                out.append(space);
                out.append(token);
                pos = maybe;
                space = "";
                continue;
            }
            while (token.length() > width) {
                out.append('\n');
                out.append(token.substring(0, width));
                token = token.substring(width);
            }
            out.append('\n');
            out.append(token);
            pos = token.length();
            space = "";
        }
        return out.toString();
    }
}

