/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util.classurl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class ClassURLConnection
extends URLConnection {
    private static String defaultAnchor = null;
    private Class<?> anchorClass = null;

    public static void setDefaultAnchor(String className) {
        defaultAnchor = className;
    }

    public ClassURLConnection(URL url) {
        super(url);
    }

    public String getContentType() {
        return ClassURLConnection.guessContentTypeFromName(this.url.getPath());
    }

    public synchronized InputStream getInputStream() throws IOException {
        InputStream stream;
        String path;
        if (!this.connected) {
            this.connect();
        }
        if ((path = this.url.getPath()).startsWith("/")) {
            path = path.substring(1);
        }
        if ((stream = this.anchorClass.getClassLoader().getResourceAsStream(path)) == null) {
            throw new IOException("cannot get stream for url: " + this.url + " from anchor: " + this.anchorClass.getName());
        }
        return stream;
    }

    public synchronized void connect() throws IOException {
        String className = this.url.getHost();
        if ("".equals(className)) {
            if (defaultAnchor == null) {
                throw new IOException("defaultAnchor must be set before using urls without a hostname");
            }
            className = defaultAnchor;
        }
        try {
            this.anchorClass = Class.forName(className);
            this.connected = true;
        }
        catch (ClassNotFoundException e) {
            IOException e2 = new IOException("Class " + className + " not found, cannot connect to URL " + this.url);
            e2.initCause(e);
            throw e2;
        }
    }
}

