/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util.ref;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WeakAssociation<K, V> {
    private static final int CLEANUP_CYCLE = 1000;
    private final Map<K, WeakReference<V>> references = new WeakHashMap<K, WeakReference<V>>();
    private int accessCount = 0;

    public V get(K key) {
        this.maybeCleanup();
        WeakReference<V> reference = this.references.get(key);
        if (reference == null) {
            return null;
        }
        Object value = reference.get();
        if (value == null) {
            this.references.remove(key);
        }
        return (V)value;
    }

    public void put(K key, V value) {
        this.maybeCleanup();
        this.references.put(key, new WeakReference<V>(value));
    }

    public void clear() {
        this.references.clear();
    }

    private void maybeCleanup() {
        ++this.accessCount;
        if (this.accessCount < 1000) {
            return;
        }
        this.accessCount = 0;
        Iterator<Map.Entry<K, WeakReference<V>>> it = this.references.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<K, WeakReference<V>> entry = it.next();
            if (entry.getValue().get() != null) continue;
            it.remove();
        }
    }
}

