/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util.ui;

import java.awt.GridBagConstraints;
import java.awt.Insets;

public final class GridBagConstraints2
extends GridBagConstraints {
    public static GridBagConstraints2 gc() {
        return new GridBagConstraints2();
    }

    public GridBagConstraints2() {
    }

    public GridBagConstraints2(GridBagConstraints defaults) {
        this.gridx = defaults.gridx;
        this.gridy = defaults.gridy;
        this.gridwidth = defaults.gridwidth;
        this.gridheight = defaults.gridheight;
        this.weightx = defaults.weightx;
        this.weighty = defaults.weighty;
        this.anchor = defaults.anchor;
        this.fill = defaults.fill;
        this.insets = defaults.insets;
        this.ipadx = defaults.ipadx;
        this.ipady = defaults.ipady;
    }

    public GridBagConstraints2 pos(int x, int y) {
        return this.posX(x).posY(y);
    }

    public GridBagConstraints2 posRelative() {
        return this.posRelativeX().posRelativeY();
    }

    public GridBagConstraints2 posX(int x) {
        if (x < 0) {
            throw new IllegalArgumentException("expected x >= 0");
        }
        return this.gridx(x);
    }

    public GridBagConstraints2 posY(int y) {
        if (y < 0) {
            throw new IllegalArgumentException("expected y >= 0");
        }
        return this.gridy(y);
    }

    public GridBagConstraints2 posRelativeX() {
        return this.gridx(-1);
    }

    public GridBagConstraints2 posRelativeY() {
        return this.gridy(-1);
    }

    private GridBagConstraints2 gridx(int gridx) {
        GridBagConstraints2 c = new GridBagConstraints2(this);
        c.gridx = gridx;
        return c;
    }

    private GridBagConstraints2 gridy(int gridy) {
        GridBagConstraints2 c = new GridBagConstraints2(this);
        c.gridy = gridy;
        return c;
    }

    public GridBagConstraints2 size(int x, int y) {
        return this.sizeX(x).sizeY(y);
    }

    public GridBagConstraints2 sizeRelative() {
        return this.sizeRelativeX().sizeRelativeY();
    }

    public GridBagConstraints2 sizeRemainder() {
        return this.sizeRemainderX().sizeRemainderY();
    }

    public GridBagConstraints2 sizeX(int x) {
        if (x < 0) {
            throw new IllegalArgumentException("expected x >= 0");
        }
        return this.gridwidth(x);
    }

    public GridBagConstraints2 sizeY(int y) {
        if (y < 0) {
            throw new IllegalArgumentException("expected y >= 0");
        }
        return this.gridheight(y);
    }

    public GridBagConstraints2 sizeRelativeX() {
        return this.gridwidth(-1);
    }

    public GridBagConstraints2 sizeRelativeY() {
        return this.gridheight(-1);
    }

    public GridBagConstraints2 sizeRemainderX() {
        return this.gridwidth(0);
    }

    public GridBagConstraints2 sizeRemainderY() {
        return this.gridheight(0);
    }

    private GridBagConstraints2 gridwidth(int gridwidth) {
        GridBagConstraints2 c = new GridBagConstraints2(this);
        c.gridwidth = gridwidth;
        return c;
    }

    private GridBagConstraints2 gridheight(int gridheight) {
        GridBagConstraints2 c = new GridBagConstraints2(this);
        c.gridheight = gridheight;
        return c;
    }

    public GridBagConstraints2 weight(double x, double y) {
        return this.weightX(x).weightY(y);
    }

    public GridBagConstraints2 weightX(double x) {
        if (x < 0.0 || x > 1.0) {
            throw new IllegalArgumentException("expected 0 <= x <= 1");
        }
        GridBagConstraints2 c = new GridBagConstraints2(this);
        c.weightx = x;
        return c;
    }

    public GridBagConstraints2 weightY(double y) {
        if (y < 0.0 || y > 1.0) {
            throw new IllegalArgumentException("expected 0 <= y <= 1");
        }
        GridBagConstraints2 c = new GridBagConstraints2(this);
        c.weighty = y;
        return c;
    }

    public GridBagConstraints2 ipad(int x, int y) {
        return this.ipadX(x).ipadY(y);
    }

    public GridBagConstraints2 ipadX(int x) {
        if (x < 0) {
            throw new IllegalArgumentException("expected x >= 0");
        }
        GridBagConstraints2 c = new GridBagConstraints2(this);
        c.ipadx = x;
        return c;
    }

    public GridBagConstraints2 ipadY(int y) {
        if (y < 0) {
            throw new IllegalArgumentException("expected y >= 0");
        }
        GridBagConstraints2 c = new GridBagConstraints2(this);
        c.ipady = y;
        return c;
    }

    public GridBagConstraints2 insets(int top, int left, int bottom, int right) {
        return this.insetsTop(top).insetsLeft(left).insetsBottom(bottom).insetsRight(right);
    }

    public GridBagConstraints2 insetsHorizontal(int left, int right) {
        return this.insetsLeft(left).insetsRight(right);
    }

    public GridBagConstraints2 insetsVertical(int top, int bottom) {
        return this.insetsTop(top).insetsBottom(bottom);
    }

    public GridBagConstraints2 insetsTop(int top) {
        if (top < 0) {
            throw new IllegalArgumentException("expected top >= 0");
        }
        return this.insets(new Insets(top, this.insets.left, this.insets.bottom, this.insets.right));
    }

    public GridBagConstraints2 insetsLeft(int left) {
        if (left < 0) {
            throw new IllegalArgumentException("expected left >= 0");
        }
        return this.insets(new Insets(this.insets.top, left, this.insets.bottom, this.insets.right));
    }

    public GridBagConstraints2 insetsBottom(int bottom) {
        if (bottom < 0) {
            throw new IllegalArgumentException("expected bottom >= 0");
        }
        return this.insets(new Insets(this.insets.top, this.insets.left, bottom, this.insets.right));
    }

    public GridBagConstraints2 insetsRight(int right) {
        if (right < 0) {
            throw new IllegalArgumentException("expected top >= 0");
        }
        return this.insets(new Insets(this.insets.top, this.insets.left, this.insets.bottom, right));
    }

    public GridBagConstraints2 insets(Insets insets) {
        GridBagConstraints2 c = new GridBagConstraints2(this);
        c.insets = (Insets)insets.clone();
        return c;
    }

    public GridBagConstraints2 anchorCenter() {
        return this.anchor(10);
    }

    public GridBagConstraints2 anchorNorth() {
        return this.anchor(11);
    }

    public GridBagConstraints2 anchorSouth() {
        return this.anchor(15);
    }

    public GridBagConstraints2 anchorEast() {
        return this.anchor(13);
    }

    public GridBagConstraints2 anchorWest() {
        return this.anchor(17);
    }

    public GridBagConstraints2 anchorNorthEast() {
        return this.anchor(12);
    }

    public GridBagConstraints2 anchorNorthWest() {
        return this.anchor(18);
    }

    public GridBagConstraints2 anchorSouthEast() {
        return this.anchor(14);
    }

    public GridBagConstraints2 anchorSouthWest() {
        return this.anchor(16);
    }

    public GridBagConstraints2 anchorPageStart() {
        return this.anchor(19);
    }

    public GridBagConstraints2 anchorPageEnd() {
        return this.anchor(20);
    }

    public GridBagConstraints2 anchorLineStart() {
        return this.anchor(21);
    }

    public GridBagConstraints2 anchorLineEnd() {
        return this.anchor(22);
    }

    public GridBagConstraints2 anchorFirstLineStart() {
        return this.anchor(23);
    }

    public GridBagConstraints2 anchorFirstLineEnd() {
        return this.anchor(24);
    }

    public GridBagConstraints2 anchorLastLineStart() {
        return this.anchor(25);
    }

    public GridBagConstraints2 anchorLastLineEnd() {
        return this.anchor(25);
    }

    private GridBagConstraints2 anchor(int anchor) {
        GridBagConstraints2 c = new GridBagConstraints2(this);
        c.anchor = anchor;
        return c;
    }

    public GridBagConstraints2 fillNone() {
        return this.fill(0);
    }

    public GridBagConstraints2 fillHorizontal() {
        return this.fill(2);
    }

    public GridBagConstraints2 fillVertical() {
        return this.fill(3);
    }

    public GridBagConstraints2 fillBoth() {
        return this.fill(1);
    }

    private GridBagConstraints2 fill(int fill) {
        GridBagConstraints2 c = new GridBagConstraints2(this);
        c.fill = fill;
        return c;
    }
}

