package net.psammead.mwapi.ui.action.parser;

import java.net.URL;

import net.psammead.mwapi.Location;
import net.psammead.mwapi.connection.URLManager;
import net.psammead.mwapi.net.IllegalFormException;
import net.psammead.mwapi.net.JerichoUtil;
import net.psammead.mwapi.ui.Page;
import net.psammead.mwapi.ui.UnsupportedURLException;
import net.psammead.util.TextUtil;
import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.FormField;
import au.id.jericho.lib.html.FormFields;
import au.id.jericho.lib.html.Source;

/** 
 * the decoded data of an editform. the body uses unix-EOLs.
 * throws a EditException when something in the form is missing.
 */
public class ParsedEditForm {
	public final boolean	conflict;
	public final Location	location;
	public final String		body;
	public final String		editTime;
	public final String		startTime;
	public final String		editToken;
	public final boolean	watchThis;
	public final boolean	watchKnown;
	
	/** returns a Page representation of this form */
	public Page page(boolean fresh) {
		return new Page(location, body, editTime, startTime, editToken, watchThis, watchKnown, fresh);
	}

	public ParsedEditForm(URLManager urlManager, URL formURL, Source source) throws IllegalFormException {
		Element		form	= JerichoUtil.fetchForm(source, "editform", "editform", -1);
		FormFields	fields	= form.findFormFields();
		
		try {
			URL	url		= JerichoUtil.fetchActionURL(formURL, form);
			location	= urlManager.anyURLToLocation(url);
			if (location == null)	throw new IllegalFormException("actionURL cannot be converted to a title: " + url);
		}
		catch (UnsupportedURLException e) {
			throw new IllegalFormException("encoding problem url", e);
		}
		
		body	= TextUtil.unixLF(JerichoUtil.fetchStringField(fields, "wpTextbox1"));
		
		// only conflict displays have this field
		conflict	= fields.get("wpTextbox2") != null;
		
		editTime	= JerichoUtil.fetchStringField(fields, "wpEdittime");
		
		// old versions do not have this field
		FormField	wpStarttime	= fields.get("wpStarttime");
		if (wpStarttime != null) {
			startTime	= (String)wpStarttime.getValues().iterator().next();
		}
		else {
			startTime	= null; 
		}
		
		// anonymous users do not get this input field (???)
		FormField	wpEditToken	= fields.get("wpEditToken");
		if (wpEditToken != null) {
			editToken	= (String)wpEditToken.getValues().iterator().next();
		}
		else {
			editToken	= null;
		}
		
		// anonymous users do not get this input field
		FormField	wpWatchthis	= fields.get("wpWatchthis");
		if (wpWatchthis != null) {
			watchThis	= wpWatchthis.getValues().size() != 0;
			watchKnown	= true;
		}
		else {
			watchThis	= false;
			watchKnown	= false;
		}
	}
}