package net.psammead.mwapi.yurik.json;

import java.util.ArrayList;
import java.util.List;

public class ListIter implements JSONConverter {
	private final JSONConverter	sub;
	
	public ListIter(JSONConverter sub) {
		this.sub = sub;
	}
	
	@SuppressWarnings("unchecked")
	public Object convert(JSONConverterContext ctx, Object o) throws JSONConverterException {
		if (!(o instanceof List))	throw new JSONConverterException("expected a List: " + o);
		List data	= (List)o;
		
		List out	= new ArrayList();
		for (Object i : data) {
			out.add(sub.convert(ctx, i));
		}
		return out;
	}
}
