package net.psammead.util;



public final class Filters {
	private Filters() {}
	
//	@SuppressWarnings("unchecked")
//	public static <VALUE> Filter[] array(Iterable<Function<VALUE,Boolean>> filters) {
//		List<Function<VALUE,Boolean>>	tmp	= new ArrayList<Function<VALUE,Boolean>>();
//		for (Function<VALUE,Boolean> filter : filters)	tmp.add(filter);
//		return tmp.toArray(new Filter[0]);
//	}
	
	/** accepts every value */
	public static <VALUE> Function<VALUE,Boolean> all() {
		return new Function<VALUE,Boolean>() {
			public Boolean apply(VALUE element) {
				return true;
			}
		};
	}

	/** accepts no value */
	public static <VALUE> Function<VALUE,Boolean> none() { 
		return new Function<VALUE,Boolean>() {
			public Boolean apply(VALUE element) {
				return false;
			}
		};
	}
	
	/** accepts if the sub does not accept */
	public static <VALUE> Function<VALUE,Boolean> not(final Function<VALUE,Boolean> sub) { 
		return new Function<VALUE,Boolean>() {
			public Boolean apply(VALUE element) {
				return !sub.apply(element);
			}
		};
	}
	
	/** accepts if all subs accept */
	public static <VALUE> Function<VALUE,Boolean> and(final Function<VALUE,Boolean>... subs) {
		return new Function<VALUE,Boolean>() {
			public Boolean apply(VALUE element) {
				for (Function<VALUE,Boolean> sub : subs) {
					if (!sub.apply(element))	return false;
				}
				return true;
			}
		};
	}
	
	/** accepts if at least one sub accepts */
	public static <VALUE> Function<VALUE,Boolean> or(final Function<VALUE,Boolean>... subs) { 
		return new Function<VALUE,Boolean>() {
			public Boolean apply(VALUE element) {
				for (Function<VALUE,Boolean> sub : subs) { 
					if (sub.apply(element))	return true;
				}
				return false;
			}
		};
	}
	
	/** accepts id the value equals a given value */
	public static <VALUE> Function<VALUE,Boolean> equals(final VALUE value) { 
		return new Function<VALUE,Boolean>() {
			public Boolean apply(VALUE element) {
				return ObjectUtil.equals(element, value);
			}
		};
	}
}
