package net.psammead.util;

import java.util.HashSet;
import java.util.Set;

public final class SetUtil {
	private SetUtil() {}
	
	public static <T> Set<T> create(T... in) {
		Set<T> out	= new HashSet<T>();
		for (T element : in)	out.add(element);
		return out;
	}
	
	public static <T> Set<T> create(Iterable<T> in) {
		Set<T> out	= new HashSet<T>();
		for (T element : in)	out.add(element);
		return out;
	}
	
	public static <T,X extends T> Set<T> single(X element) {
		Set<T> out	= new HashSet<T>();
		out.add(element);
		return out;
	}
	
	public static <T> Set<T> filter(Set<T> in, Function<? super T,Boolean> filter) {
		Set<T> out	= new HashSet<T>();
		for (T element : in) {
			if (filter.apply(element)) {
				out.add(element);
			}
		}
		return out;
	}
	
	public static <S,T> Set<T> map(Set<S> in, Function<? super S,? extends T> transformer) {
		Set<T> out	= new HashSet<T>();
		for (S element : in) {
			out.add(transformer.apply(element));
		}
		return out;
	}
	 
	public static <T> Set<T> union(Set<T> a, Set<T> b) {
		Set<T> out	= new HashSet<T>();
		out.addAll(a);
		out.addAll(b);
		return out;
	}
	
	public static <T> Set<T> intersection(Set<T> a, Set<T> b) {
		Set<T> out	= new HashSet<T>();
		out.addAll(a);
		out.retainAll(b);
		return out;
	}
	
	public static <T> Set<T> without(Set<T> a, Set<T> b) {
		Set<T> out	= new HashSet<T>();
		out.addAll(a);
		out.removeAll(b);
		return out;
	}
	
	public static <T> Set<T> difference(Set<T> a, Set<T> b) {
		return without(union(a,b), intersection(a,b));
	}
	
}
