package net.psammead.commonist.util;

import net.psammead.util.DebugUtil;

/** text utility functions */
public class TextUtil {
	/** fully static utility class, shall not be instantiated */
	private TextUtil() {}
	
	/** encode a number of bytes into a human readable form */
	public static String human(long bytes) {
		long[]		factors	= { 1024*1024*1024, 1024*1024, 1024 };
		String[]	names	= { "G",            "M",       "K"  };
		for (int i=0; i<factors.length; i++) {
			if (bytes < factors[i])	continue;
			bytes	= bytes * 10 / factors[i];
			return (bytes / 10) + "." + (bytes % 10) + names[i];
		}
		return ""+bytes;
	}

//	/** returns the class name of an object without its package */
//	public static String shortClass(Object o) {
//		return o.getClass().getName().replaceAll(".*\\.", "");
//	}
	
	/** returns a single-line throwable description */
	public static String shortError(Throwable t) {
		return DebugUtil.shortClassName(t) + " " + feedToSpace(t.getMessage());
	}
	
	/** removes linefeeds from both ends of a string */
	public static String trimLF(String s) {
		return s.replaceAll("^\\n+", "").replaceAll("\\n+$", "");
	}
	
	/** replaces every linefeeds with a space */
	public static String feedToSpace(String s) {
		return s.replaceAll("\r\n|\r|\n", " ");
	}
	
	/** removes double empty lines */
	public static String restrictEmptyLines(String s) {
		return s.replaceAll("\n\n\n+", "\n\n");
	}
	
	/** concatenates two Strings and inserts a separator if both are non-empty */
	public static String compose(String string1, String string2, String separator) {
		if (string1.length() == 0 || string2.length() == 0)	separator	= "";
		return string1 + separator + string2; 
	}
}
