package net.psammead.util;

import java.util.Comparator;

/** a {@link Comparator} for {@link Comparable}s */
public final class ComparableComparator<T extends Comparable<? super T>> implements Comparator<T> {
	public int compare(T o1, T o2) {
		return o1.compareTo(o2);
	}
	
	@Override
	public String toString() {
		return new ToString(this)
				.toString();
	}
}