package net.psammead.util;

import java.io.*;

public class Logger {
	public static final String[] LEVELS = {
		"none", "debug", "info", "warn", "error"
	};
	
	public static final int NONE	= 0;
	public static final int DEBUG	= 1;
	public static final int INFO	= 2;
	public static final int WARN	= 3;
	public static final int ERROR	= 4;
	
	private PrintWriter out;
	private Object		source;
	
	public Logger(Object source) {
		this.out	= new PrintWriter(System.err);
		this.source = source;
	}

	public Logger(PrintWriter out, Object source) {
		this.out	= out;
		this.source = source;
	}
	
	public Logger(PrintStream out, Object source) {
		this(new PrintWriter(out), source);
	}
	
	public PrintWriter logWriter() {
		return out;
	}

	public void debug(String message) { log(DEBUG,	message, null); }
	public void info(String message)  { log(INFO,	message, null); }
	public void warn(String message)  { log(WARN,	message, null); }
	public void error(String message) { log(ERROR,	message, null); }
	
	public void debug(String message, Throwable error)	  { log(DEBUG,	  message, error); }
	public void info(String message, Throwable error)	  { log(INFO,	  message, error); }
	public void warn(String message, Throwable error)	  { log(WARN,	  message, error); }
	public void error(String message, Throwable error)	  { log(ERROR,	  message, error); }

	public synchronized void log(int level, String message, Throwable error) {
		if (level != NONE)		out.print(levelString(level) + "\t");
		if (source != null)		out.print(sourceString(source) + "\t");
		if (message != null)	out.print(message);
		if (level != NONE || source != null || message != null) out.println("");
		if (error != null)		error.printStackTrace(out);
		out.flush();
	}
	
	private String levelString(int level) {
		return LEVELS[level];
	}
	
	private String sourceString(Object source) {
		if (source == null)				return "<null>";
		if (source instanceof Class)	return ((Class<?>)source).getName();
		return source.toString();
	}
}
