package net.psammead.util.ref;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.Map.Entry;

/** a Map holding both key and value with a {@link WeakReference} */
public final class WeakAssociation<K,V> {
	private static final int CLEANUP_CYCLE = 1000;
	
	private final Map<K,WeakReference<V>>	references;
	private int accessCount;
	
	public WeakAssociation() {
		references	= new WeakHashMap<K,WeakReference<V>>();
		accessCount	= 0;
	}
	
	public V get(K key) {
		maybeCleanup();
		WeakReference<V> reference = references.get(key);
		if (reference == null)	return null;
		V value = reference.get();
		if (value == null)		references.remove(key);
		return value;
	}
	
	public void put(K key, V value) {
		maybeCleanup();
		references.put(key, new WeakReference<V>(value));
	}
	
	public void clear() {
		references.clear();
	}
	
	private void maybeCleanup() {
		accessCount++;
		if (accessCount < CLEANUP_CYCLE)	return;
		accessCount	= 0;
		
		for (Iterator<Map.Entry<K, WeakReference<V>>> it=references.entrySet().iterator(); it.hasNext();) {
			Entry<K, WeakReference<V>> entry = it.next();
			if (entry.getValue().get() == null)	it.remove();
		}
	}
}
