/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportInfo;
import airport.AirportInfoPanel;
import airport.AirportInfoRecord;
import airport.ValueFormatException;
import byteblock.ByteBlock;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;

public class AirportAccessControlTable
extends AirportInfoPanel {
    private AirportInfo airportInfo;
    private Vector addressVector;
    private JTable table;
    private AbstractTableModel tableModel;

    public AirportAccessControlTable(AirportInfo airportInfo) {
        this.airportInfo = airportInfo;
        this.setUpDisplay();
    }

    private void setUpDisplay() {
        this.refreshDisplay();
    }

    public void writeValue() throws ValueFormatException {
        AirportInfoRecord airportInfoRecord;
        TableCellEditor tableCellEditor = this.table.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
        ByteBlock byteBlock = this.airportInfo.baseBlock;
        int n = 3978;
        int n2 = 1;
        int n3 = 1536;
        int n4 = 2;
        AirportInfoRecord airportInfoRecord2 = new AirportInfoRecord(n, n2, n3, n4, byteBlock);
        airportInfoRecord2.clearWindow();
        int n5 = 7368;
        int n6 = 1;
        int n7 = 5120;
        int n8 = 0;
        AirportInfoRecord airportInfoRecord3 = new AirportInfoRecord(n5, n6, n7, n8, byteBlock);
        airportInfoRecord3.clearWindow();
        int n9 = 0;
        n = 3978;
        n2 = 1;
        n3 = 6;
        n4 = 2;
        n5 = 7368;
        n6 = 1;
        n7 = 20;
        n8 = 0;
        int n10 = 0;
        while (n10 < this.addressVector.size()) {
            try {
                if (!((String[])this.addressVector.elementAt(n10))[0].equals("")) {
                    airportInfoRecord = new AirportInfoRecord(n, n2, n3, n4, byteBlock);
                    airportInfoRecord.setBytesFromString(((String[])this.addressVector.elementAt(n10))[0]);
                    n += 6;
                    ++n9;
                }
            }
            catch (ValueFormatException valueFormatException) {
                this.table.editCellAt(n10, 0);
                throw valueFormatException;
            }
            try {
                airportInfoRecord = new AirportInfoRecord(n5, n6, n7, n8, byteBlock);
                airportInfoRecord.setBytesFromString(((String[])this.addressVector.elementAt(n10))[1]);
                n5 += 20;
            }
            catch (ValueFormatException valueFormatException) {
                this.table.editCellAt(n10, 1);
                throw valueFormatException;
            }
            ++n10;
        }
        int n11 = 3975;
        int n12 = 1;
        int n13 = 2;
        int n14 = 4;
        airportInfoRecord = new AirportInfoRecord(n11, n12, n13, n14, byteBlock);
        String string = new String();
        string = String.valueOf(string) + n9;
        airportInfoRecord.setBytesFromString(string);
        String string2 = new String();
        string2 = n9 > 0 ? "80" : "00";
        AirportInfoRecord airportInfoRecord4 = this.airportInfo.get("Access control switch");
        airportInfoRecord4.setBytesFromString(string2);
    }

    public void refreshDisplay() {
        Object object;
        ByteBlock byteBlock = this.airportInfo.baseBlock;
        int n = 3975;
        int n2 = 1;
        int n3 = 2;
        int n4 = 4;
        AirportInfoRecord airportInfoRecord = new AirportInfoRecord(n, n2, n3, n4, byteBlock);
        String string = airportInfoRecord.toString();
        int n5 = 0;
        try {
            n5 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Problem with number of Mac addresses");
        }
        this.addressVector = new Vector();
        int n6 = 3978;
        int n7 = 1;
        int n8 = 6;
        int n9 = 2;
        int n10 = 7368;
        int n11 = 1;
        int n12 = 20;
        int n13 = 0;
        int n14 = 0;
        while (n14 < n5) {
            object = new AirportInfoRecord(n6, n7, n8, n9, byteBlock);
            AirportInfoRecord airportInfoRecord2 = new AirportInfoRecord(n10, n11, n12, n13, byteBlock);
            String[] stringArray = new String[]{((AirportInfoRecord)object).toString(), airportInfoRecord2.toString()};
            this.addressVector.insertElementAt(stringArray, this.addressVector.size());
            n6 += 6;
            n10 += 20;
            ++n14;
        }
        this.removeAll();
        this.tableModel = new AccessAddressTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setCellSelectionEnabled(true);
        this.table.setPreferredScrollableViewportSize(new Dimension(350, 200));
        object = new JScrollPane(this.table);
        this.add((Component)object);
    }

    private class AccessAddressTableModel
    extends AbstractTableModel {
        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return 256;
        }

        public boolean isCellEditable(int n, int n2) {
            return n <= AirportAccessControlTable.this.addressVector.size();
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return "MAC address";
            }
            return "Host name (opt)";
        }

        public Object getValueAt(int n, int n2) {
            if (n < AirportAccessControlTable.this.addressVector.size()) {
                return ((String[])AirportAccessControlTable.this.addressVector.elementAt(n))[n2];
            }
            return "";
        }

        public void setValueAt(Object object, int n, int n2) {
            if (object instanceof String) {
                if (n < AirportAccessControlTable.this.addressVector.size()) {
                    String[] stringArray = (String[])AirportAccessControlTable.this.addressVector.elementAt(n);
                    stringArray[n2] = (String)object;
                } else {
                    String[] stringArray = new String[]{"", ""};
                    stringArray[n2] = (String)object;
                    AirportAccessControlTable.this.addressVector.insertElementAt(stringArray, AirportAccessControlTable.this.addressVector.size());
                }
            }
        }

        AccessAddressTableModel() {
        }
    }
}

