/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportInfo;
import airport.AirportInfoCheckBox;
import airport.AirportInfoLabelledTextField;
import airport.AirportInfoPanel;
import airport.AirportInfoRadioButton;
import airport.AirportInfoTextField;
import airport.ValueFormatException;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;

public class AirportBridgingPanel
extends AirportInfoPanel {
    private AirportInfoRadioButton transparentBridgeButton;
    private AirportInfoRadioButton natButton;
    private ButtonGroup radioButtonGroup;
    private AirportInfoPanel natInfoPanel;
    private AirportInfoCheckBox natOnEthernetCheckbox;
    private AirportInfoCheckBox disableBridgingCheckbox;
    private AirportInfoLabelledTextField natInboundPrivateAddressBase;
    private AirportInfoLabelledTextField natInboundPrivateAddressMask;
    private AirportInfoTextField natOutboundPrivateAddressBase;
    private AirportInfoTextField natOutboundPrivateAddressMask;
    private AirportInfo theInfo;

    public AirportBridgingPanel(AirportInfo airportInfo) {
        this.theInfo = airportInfo;
        this.transparentBridgeButton = new AirportInfoRadioButton("Act as transparent bridge (no NAT)");
        this.transparentBridgeButton.addInfoRecord(airportInfo.get("NAT switch"), "00");
        this.transparentBridgeButton.addInfoRecord(airportInfo.get("Bridging switch"), "01");
        this.natButton = new AirportInfoRadioButton("Provide network address translation (NAT)");
        this.natButton.addInfoRecord(airportInfo.get("NAT switch"), "02");
        this.radioButtonGroup = new ButtonGroup();
        this.radioButtonGroup.add(this.transparentBridgeButton);
        this.radioButtonGroup.add(this.natButton);
        this.natInboundPrivateAddressBase = new AirportInfoLabelledTextField("Private LAN base station address", airportInfo.get("NAT inbound private IP address"));
        this.natInboundPrivateAddressMask = new AirportInfoLabelledTextField("Private LAN subnet mask", airportInfo.get("NAT inbound private subnet mask"));
        this.natOutboundPrivateAddressBase = new AirportInfoTextField(airportInfo.get("NAT outbound private IP address"));
        this.natOutboundPrivateAddressMask = new AirportInfoTextField(airportInfo.get("NAT outbound private subnet mask"));
        this.disableBridgingCheckbox = new AirportInfoCheckBox("Disable bridging between Ethernet port and wireless LAN", airportInfo.get("Bridging switch"), "00", "01");
        this.natInfoPanel = new AirportInfoPanel();
        this.setUpDisplay();
    }

    private void setUpDisplay() {
        Insets insets;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.natInfoPanel.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.natInboundPrivateAddressBase, gridBagConstraints);
        this.natInfoPanel.add(this.natInboundPrivateAddressBase);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.natInboundPrivateAddressMask, gridBagConstraints);
        this.natInfoPanel.add(this.natInboundPrivateAddressMask);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.disableBridgingCheckbox, gridBagConstraints);
        this.natInfoPanel.add(this.disableBridgingCheckbox);
        this.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.transparentBridgeButton, gridBagConstraints);
        this.add(this.transparentBridgeButton);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.natButton, gridBagConstraints);
        this.add(this.natButton);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.natInfoPanel, gridBagConstraints);
        this.add(this.natInfoPanel);
        this.natButton.addItemListener(this.natInfoPanel);
        this.natInfoPanel.setEnabled(this.natButton.isSelected());
    }

    public void writeValue() throws ValueFormatException {
        super.writeValue();
        if (this.natInfoPanel.isEnabled()) {
            this.natInboundPrivateAddressBase.writeValue();
            String string = this.theInfo.get("NAT inbound private IP address").toString();
            if (string.equals("0.0.0.0")) {
                this.natInboundPrivateAddressBase.theField.selectAll();
                this.natInboundPrivateAddressBase.theField.requestFocus();
                throw new ValueFormatException("Private LAN IP address in Bridging panel can't be 0.0.0.0");
            }
            this.natOutboundPrivateAddressBase.writeValue(this.natInboundPrivateAddressBase.getText());
            this.natOutboundPrivateAddressMask.writeValue(this.natInboundPrivateAddressMask.getText());
        }
    }
}

