/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportAccessControlTable;
import airport.AirportAdvancedPanel;
import airport.AirportBridgingPanel;
import airport.AirportDHCPPanel;
import airport.AirportInfo;
import airport.AirportInfoPanel;
import airport.AirportMainPanel;
import airport.AirportNetworkPanel;
import airport.AirportPortMappingPanel;
import airport.AirportSNMPPanel;
import airport.AirportWirelessPanel;
import airport.ValueFormatException;
import java.awt.Component;
import javax.swing.JTabbedPane;

public class AirportInfoTabbedPane
extends JTabbedPane {
    public AirportInfoTabbedPane(AirportInfo airportInfo) {
        this.setUpDisplay(airportInfo);
    }

    private void setUpDisplay(AirportInfo airportInfo) {
        AirportMainPanel airportMainPanel = new AirportMainPanel(airportInfo);
        AirportWirelessPanel airportWirelessPanel = new AirportWirelessPanel(airportInfo);
        AirportNetworkPanel airportNetworkPanel = new AirportNetworkPanel(airportInfo);
        AirportBridgingPanel airportBridgingPanel = new AirportBridgingPanel(airportInfo);
        AirportDHCPPanel airportDHCPPanel = new AirportDHCPPanel(airportInfo);
        AirportAccessControlTable airportAccessControlTable = new AirportAccessControlTable(airportInfo);
        AirportPortMappingPanel airportPortMappingPanel = new AirportPortMappingPanel(airportInfo);
        AirportSNMPPanel airportSNMPPanel = new AirportSNMPPanel(airportInfo);
        AirportAdvancedPanel airportAdvancedPanel = new AirportAdvancedPanel(airportInfo);
        this.addTab("Main", airportMainPanel);
        this.addTab("Wireless LAN Settings", airportWirelessPanel);
        this.addTab("Network Connection", airportNetworkPanel);
        this.addTab("Bridging Functions", airportBridgingPanel);
        this.addTab("DHCP Functions", airportDHCPPanel);
        this.addTab("Access Control", airportAccessControlTable);
        this.addTab("Port Mappings", airportPortMappingPanel);
        this.addTab("SNMP Settings", airportSNMPPanel);
        this.addTab("Advanced Settings", airportAdvancedPanel);
    }

    public void writeData() throws ValueFormatException {
        int n = this.getTabCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = this.getComponentAt(n2);
            if (component instanceof AirportInfoPanel) {
                try {
                    ((AirportInfoPanel)component).writeValue();
                }
                catch (ValueFormatException valueFormatException) {
                    this.setSelectedIndex(n2);
                    throw valueFormatException;
                }
            }
            ++n2;
        }
    }
}

