/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportInfo;
import airport.AirportInfoPanel;
import airport.AirportInfoRecord;
import airport.ValueFormatException;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;

public class AirportLoginStringTable
extends AirportInfoPanel {
    private AirportInfo airportInfo;
    private Vector tableContentsVector;
    private JTable table;
    private JScrollPane tableScrollPane;
    private AbstractTableModel tableModel;
    private JComboBox elementTypeComboBox;
    private final int MAX_NUM_LOGIN_STRING_ENTRIES = 20;

    public AirportLoginStringTable(AirportInfo airportInfo) {
        this.airportInfo = airportInfo;
        this.tableContentsVector = new Vector();
        this.elementTypeComboBox = new JComboBox();
        this.elementTypeComboBox.addItem("");
        this.elementTypeComboBox.addItem("Expect string");
        this.elementTypeComboBox.addItem("Send string");
        this.elementTypeComboBox.addItem("Delay (seconds)");
        this.setUpDisplay();
    }

    private void setUpDisplay() {
        this.refreshDisplay();
    }

    public void writeValue() throws ValueFormatException {
        TableCellEditor tableCellEditor = this.table.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
        AirportInfoRecord airportInfoRecord = this.airportInfo.get("Login information string");
        airportInfoRecord.clearWindow();
        byte[] byArray = new byte[127];
        int n = 0;
        int n2 = 0;
        while (n2 < this.tableContentsVector.size()) {
            String string = (String)((Object[])this.tableContentsVector.elementAt(n2))[0];
            String string2 = (String)((Object[])this.tableContentsVector.elementAt(n2))[1];
            boolean bl = (Boolean)((Object[])this.tableContentsVector.elementAt(n2))[2];
            if (!string.equals("")) {
                try {
                    if (string.equals("Expect string") || string.equals("Send string")) {
                        if (string.equals("Expect string")) {
                            byArray[n] = -128;
                        } else if (string.equals("Send string")) {
                            byArray[n] = 64;
                        }
                        int n3 = n;
                        byArray[n3] = (byte)(byArray[n3] + string2.length());
                        if (bl) {
                            int n4 = n;
                            byArray[n4] = (byte)(byArray[n4] + 1);
                        }
                        ++n;
                        byte[] byArray2 = string2.getBytes();
                        int n5 = 0;
                        while (n5 < string2.length()) {
                            byArray[n] = byArray2[n5];
                            ++n;
                            ++n5;
                        }
                        if (bl) {
                            byArray[n] = 13;
                            ++n;
                        }
                    } else if (string.equals("Delay (seconds)")) {
                        int n6 = Integer.parseInt(string2);
                        byArray[n] = (byte)(192 + n6);
                        ++n;
                        if (n6 < 0 || n6 > 63) {
                            this.table.editCellAt(n2, 1);
                            throw new ValueFormatException("Delay must be between 0 and 63 seconds");
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.table.editCellAt(n2, 1);
                    throw new ValueFormatException("Bad delay value");
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new ValueFormatException("Login string too long (maximum size 127 characters)");
                }
                airportInfoRecord.byteBlockWindow.writeBytes(byArray);
            }
            ++n2;
        }
    }

    public void refreshDisplay() {
        AirportInfoRecord airportInfoRecord = this.airportInfo.get("Login information string");
        byte[] byArray = airportInfoRecord.byteBlockWindow.getBytes();
        int n = 0;
        block4: while (n < byArray.length) {
            int n2 = byArray[n];
            ++n;
            if (n2 < 0) {
                n2 += 256;
            }
            int n3 = n2 % 64;
            int n4 = n2 - n3;
            switch (n4) {
                case 192: {
                    Object object = new Object[]{"Delay (seconds)", Integer.toString(n3), new Boolean(false)};
                    this.tableContentsVector.insertElementAt(object, this.tableContentsVector.size());
                    continue block4;
                }
                case 64: 
                case 128: {
                    boolean bl;
                    Object object = new String(byArray);
                    object = object.substring(n, n + n3);
                    if (byArray[(n += n3) - 1] == 13) {
                        object = object.substring(0, n3 - 1);
                        bl = true;
                    } else {
                        bl = false;
                    }
                    Object[] objectArray = new Object[3];
                    objectArray[1] = object;
                    objectArray[2] = new Boolean(bl);
                    objectArray[0] = n4 == 64 ? "Send string" : "Expect string";
                    this.tableContentsVector.insertElementAt(objectArray, this.tableContentsVector.size());
                    continue block4;
                }
            }
        }
        this.removeAll();
        this.tableModel = new LoginStringTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setCellSelectionEnabled(true);
        this.table.getColumn("Element type").setCellEditor(new DefaultCellEditor(this.elementTypeComboBox));
        this.table.setPreferredScrollableViewportSize(new Dimension(300, 150));
        this.tableScrollPane = new JScrollPane(this.table);
        this.add(this.tableScrollPane);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.table.setEnabled(bl);
    }

    private class LoginStringTableModel
    extends AbstractTableModel {
        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return 20;
        }

        public boolean isCellEditable(int n, int n2) {
            if (n <= AirportLoginStringTable.this.tableContentsVector.size()) {
                if (n2 < 2) {
                    return true;
                }
                if (n == AirportLoginStringTable.this.tableContentsVector.size()) {
                    return false;
                }
                Object[] objectArray = (Object[])AirportLoginStringTable.this.tableContentsVector.elementAt(n);
                return ((String)objectArray[0]).equals("Send string") || ((String)objectArray[0]).equals("Expect string");
            }
            return false;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Element type";
                }
                case 1: {
                    return "Value";
                }
            }
            return "Carriage return";
        }

        public Class getColumnClass(int n) {
            String string = "";
            Boolean bl = new Boolean(true);
            switch (n) {
                case 0: {
                    return string.getClass();
                }
                case 1: {
                    return string.getClass();
                }
            }
            return bl.getClass();
        }

        public Object getValueAt(int n, int n2) {
            if (n < AirportLoginStringTable.this.tableContentsVector.size()) {
                return ((Object[])AirportLoginStringTable.this.tableContentsVector.elementAt(n))[n2];
            }
            if (n2 < 2) {
                return "";
            }
            return new Boolean(false);
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n < AirportLoginStringTable.this.tableContentsVector.size()) {
                Object[] objectArray = (Object[])AirportLoginStringTable.this.tableContentsVector.elementAt(n);
                objectArray[n2] = object;
                if (n2 == 0 && ((String)object).equals("Delay (seconds)")) {
                    objectArray[2] = new Boolean(false);
                    this.fireTableCellUpdated(n, 2);
                }
            } else {
                Object[] objectArray = new Object[]{"", "", new Boolean(false)};
                objectArray[n2] = object;
                AirportLoginStringTable.this.tableContentsVector.insertElementAt(objectArray, AirportLoginStringTable.this.tableContentsVector.size());
            }
            this.fireTableCellUpdated(n, n2);
        }

        LoginStringTableModel() {
        }
    }
}

