/*
 * Decompiled with CFR 0.152.
 */
package snmp;

import java.math.BigInteger;
import snmp.SNMPBadValueException;
import snmp.SNMPInteger;

public class SNMPCounter64
extends SNMPInteger {
    private static BigInteger maxValue = new BigInteger("18446744070000000000");
    protected byte tag = (byte)70;

    public SNMPCounter64() {
        this(0L);
    }

    public SNMPCounter64(long l) {
        this.value = new BigInteger(new Long(l).toString());
        this.value = this.value.mod(maxValue);
    }

    public SNMPCounter64(byte[] byArray) throws SNMPBadValueException {
        this.extractValueFromBEREncoding(byArray);
        this.value = this.value.mod(maxValue);
    }

    public void setValue(Object object) throws SNMPBadValueException {
        if (object instanceof BigInteger) {
            this.value = (BigInteger)object;
            this.value = this.value.mod(maxValue);
        } else if (object instanceof Integer) {
            this.value = this.value = new BigInteger(object.toString());
            this.value = this.value.mod(maxValue);
        } else if (object instanceof String) {
            this.value = this.value = new BigInteger((String)object);
            this.value = this.value.mod(maxValue);
        } else {
            throw new SNMPBadValueException(" Counter64: bad object supplied to set value ");
        }
    }
}

