/*
 * Decompiled with CFR 0.152.
 */
package snmp;

import java.io.ByteArrayOutputStream;
import snmp.SNMPBERCodec;
import snmp.SNMPBadValueException;
import snmp.SNMPObject;

public class SNMPOctetString
extends SNMPObject {
    protected byte[] data;
    protected byte tag = (byte)4;

    public SNMPOctetString() {
        this.data = new byte[0];
    }

    public SNMPOctetString(String string) {
        this.data = string.getBytes();
    }

    public SNMPOctetString(byte[] byArray) {
        this.extractFromBEREncoding(byArray);
    }

    public Object getValue() {
        return this.data;
    }

    public void setValue(Object object) throws SNMPBadValueException {
        if (object instanceof byte[]) {
            this.data = (byte[])object;
        } else if (object instanceof String) {
            this.data = ((String)object).getBytes();
        } else {
            throw new SNMPBadValueException(" Octet String: bad object supplied to set value ");
        }
    }

    public byte[] getBEREncoding() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = SNMPBERCodec.encodeLength(this.data.length);
        byteArrayOutputStream.write(this.tag);
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        byteArrayOutputStream.write(this.data, 0, this.data.length);
        return byteArrayOutputStream.toByteArray();
    }

    protected void extractFromBEREncoding(byte[] byArray) {
        this.data = new byte[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            this.data[n] = byArray[n];
            ++n;
        }
    }

    public String toString() {
        String string = new String(this.data);
        return string;
    }

    private String hexByte(byte n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        String string = new String();
        string = String.valueOf(string) + Integer.toHexString(n2 / 16);
        string = String.valueOf(string) + Integer.toHexString(n2 % 16);
        return string;
    }

    public String toHexString() {
        String string = new String();
        int n = 0;
        while (n < this.data.length) {
            string = String.valueOf(string) + this.hexByte(this.data[n]) + " ";
            ++n;
        }
        return string;
    }
}

